/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.plat.wf.model;

import com.gtis.plat.wf.model.PerformerModel;
import com.gtis.plat.wf.model.PerformerTaskModel;
import com.gtis.plat.wf.model.ResourceModel;
import com.gtis.plat.wf.model.RiskModel;
import com.gtis.plat.wf.model.SubProcessModel;
import com.gtis.plat.wf.model.TransitionModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.dom4j.Node;

public class ActivityModel
implements Serializable {
    private static final long serialVersionUID = -3552168065400002455L;
    private static final Log log = LogFactory.getLog(ActivityModel.class);
    private String defineId;
    private Node activityNode;
    private boolean canFinish = false;
    private boolean mutiSelect = false;
    private boolean selectAll = true;
    private boolean waitAllUsers = false;
    private boolean specialFinish = false;
    private boolean sendSMS = false;
    private boolean quickTurn = false;
    private boolean requiredOpinion = false;
    private int CooperState = -1;
    private String cooperRootId;
    private String defaultSelectName;
    private String filterInfo;
    private String filterUrl;
    private boolean canDelOthers = false;
    private SubProcessModel subProcess;
    private static final String BACKOPTION = "BackOption";
    private static final String ORGANID = "OrganId";
    private static final String DEFAULTSELECTNEXTNAME = "DefaultSelectNextNodeName";
    private static final String REQUIREDOPINION = "RequiredOpinion";
    private static final String FILTERINFO = "FilterInfo";
    private static final String TURNINFOURL = "TurnInfoUrl";
    private static final String SENDSMS = "SendSMS";
    private static final String SPECIALFINISH = "SpecialFinish";
    private static final String QUICKTURN = "QuickTurn";
    private static final String CANDElOTHERS = "CanDelOthers";
    private static final String ENABLEDNEXTWORKFLOW = "EnabledNextWorkflow";
    private static final String AUTOLOCK = "AutoLock";
    private List<PerformerTaskModel> performerModelList;
    private List<RiskModel> riskModelList;
    private boolean waitAllActivitysFinish = false;

    public ActivityModel(Node aNode) {
        Node subFlowNode;
        this.activityNode = aNode;
        this.riskModelList = this.getRiskModelList();
        this.defineId = this.activityNode.valueOf("@Id");
        if (this.getExtendedAttribute("CanFinish").equalsIgnoreCase("true")) {
            this.canFinish = true;
        }
        if (this.getExtendedAttribute(CANDElOTHERS).equalsIgnoreCase("true")) {
            this.canDelOthers = true;
        }
        if (this.getExtendedAttribute("MutiSelect").equalsIgnoreCase("true")) {
            this.mutiSelect = true;
        }
        if (this.getExtendedAttribute("SelectAll").equalsIgnoreCase("false")) {
            this.selectAll = false;
        }
        if (this.getExtendedAttribute("WaitAllUsers").equalsIgnoreCase("true")) {
            this.waitAllUsers = true;
        }
        if (this.getExtendedAttribute(REQUIREDOPINION).equalsIgnoreCase("true")) {
            this.requiredOpinion = true;
        }
        if (this.getExtendedAttribute(SENDSMS).equalsIgnoreCase("true")) {
            this.sendSMS = true;
        }
        if (this.getExtendedAttribute(SPECIALFINISH).equalsIgnoreCase("true")) {
            this.specialFinish = true;
        }
        if (this.getExtendedAttribute(QUICKTURN).equalsIgnoreCase("true")) {
            this.quickTurn = true;
        }
        if (this.getExtendedAttribute("COOPERATION").equals("1")) {
            this.CooperState = 1;
        } else if (this.getExtendedAttribute("COOPERATION").equals("2")) {
            this.CooperState = 2;
        }
        this.cooperRootId = this.getExtendedAttribute("COOPERROOTID");
        this.defaultSelectName = this.getExtendedAttribute(DEFAULTSELECTNEXTNAME);
        if (this.getExtendedAttribute("WaitAllActivitysFinish").equalsIgnoreCase("true")) {
            this.waitAllActivitysFinish = true;
        }
        if ((subFlowNode = this.activityNode.selectSingleNode("SubFlow")) != null && StringUtils.isNotBlank((String)subFlowNode.valueOf("@Id"))) {
            this.subProcess = new SubProcessModel(subFlowNode);
        }
    }

    public String getExtendedAttribute(String aName) {
        Node tmpNode = this.activityNode.selectSingleNode("ExtendedAttributes/ExtendedAttribute[@Name='" + aName + "']");
        if (tmpNode != null) {
            return tmpNode.valueOf("@Value");
        }
        return "";
    }

    public List<TransitionModel> getTransitionsList() {
        Element activityEle = (Element)this.activityNode;
        ArrayList<TransitionModel> lstResult = new ArrayList<TransitionModel>();
        List lstNodes = activityEle.selectNodes("//Transitions/Transition[@From='" + this.defineId + "']");
        for (int i = 0; i < lstNodes.size(); ++i) {
            lstResult.add(new TransitionModel((Node)lstNodes.get(i)));
        }
        return lstResult;
    }

    public List<RiskModel> getRiskModelList() {
        Element activityEle = (Element)this.activityNode;
        ArrayList<RiskModel> riskModels = new ArrayList<RiskModel>();
        List lstNodes = activityEle.selectNodes("Risks/Risk");
        for (int i = 0; i < lstNodes.size(); ++i) {
            riskModels.add(new RiskModel((Node)lstNodes.get(i)));
        }
        return riskModels;
    }

    public String getBackTransitions() {
        return this.getExtendedAttribute(BACKOPTION);
    }

    public String getOrganId() {
        return this.getExtendedAttribute(ORGANID);
    }

    public String getIsRequiredOpinion() {
        return this.getExtendedAttribute(REQUIREDOPINION);
    }

    public String getIsSendSMS() {
        return this.getExtendedAttribute(SENDSMS);
    }

    public List<String> getFormActivitys() {
        Element activityEle = (Element)this.activityNode;
        ArrayList<String> lstActivitys = new ArrayList<String>();
        List lstNodes = activityEle.selectNodes("//Transitions/Transition[@To='" + this.defineId + "']");
        for (Node tmpNode : lstNodes) {
            lstActivitys.add(tmpNode.valueOf("@From"));
        }
        return lstActivitys;
    }

    public List<String> getBackTransitionsList() {
        ArrayList<String> lstResult = new ArrayList<String>();
        String backOption = this.getExtendedAttribute(BACKOPTION);
        if (backOption.equalsIgnoreCase("default")) {
            Element activityEle = (Element)this.activityNode;
            List lstNodes = activityEle.selectNodes("//Transitions/Transition[@To='" + this.defineId + "']");
            for (int i = 0; i < lstNodes.size(); ++i) {
                Node transitionNode = (Node)lstNodes.get(i);
                lstResult.add(transitionNode.valueOf("@From"));
            }
        } else {
            if (backOption.equalsIgnoreCase("NOTALLOWED")) {
                return lstResult;
            }
            String[] arrayOption = backOption.split(",");
            for (int i = 0; i < arrayOption.length; ++i) {
                lstResult.add(arrayOption[i]);
            }
        }
        return lstResult;
    }

    public String getPriority() {
        if (this.activityNode != null) {
            Node tmpNode = this.activityNode.selectSingleNode("Priority");
            return tmpNode.getText();
        }
        return "";
    }

    public String getLimit() {
        Node tmpNode;
        if (this.activityNode != null && (tmpNode = this.activityNode.selectSingleNode("Limit")).getText() != null && !tmpNode.getText().equals("")) {
            return tmpNode.getText();
        }
        return "0";
    }

    public String getSplitType() {
        Node nodeTemp;
        if (this.activityNode != null && (nodeTemp = this.activityNode.selectSingleNode("TransitionRestrictions/TransitionRestriction/Split")) != null && nodeTemp.valueOf("@Type") != null) {
            return nodeTemp.valueOf("@Type");
        }
        return "";
    }

    public String getJoinType() {
        Node nodeTemp;
        if (this.activityNode != null && (nodeTemp = this.activityNode.selectSingleNode("TransitionRestrictions/TransitionRestriction/Join")) != null && nodeTemp.valueOf("@Type") != null) {
            return nodeTemp.valueOf("@Type");
        }
        return "";
    }

    public List<PerformerModel> getPerformerList() {
        ArrayList<PerformerModel> lstUsers = new ArrayList<PerformerModel>();
        if (this.activityNode != null) {
            List lstNodes = this.activityNode.selectNodes("Performer/User");
            Iterator i = lstNodes.iterator();
            while (i.hasNext()) {
                lstUsers.add(new PerformerModel((Node)i.next()));
            }
        }
        return lstUsers;
    }

    public List<ResourceModel> getResourceList() {
        ArrayList<ResourceModel> lstRes = new ArrayList<ResourceModel>();
        if (this.activityNode != null) {
            List lstNodes = this.activityNode.selectNodes("Resources/Resource");
            Iterator i = lstNodes.iterator();
            while (i.hasNext()) {
                lstRes.add(new ResourceModel((Node)i.next()));
            }
        }
        return lstRes;
    }

    public String getActivityDescription() {
        return this.activityNode.valueOf("//Activity[@Id='" + this.defineId + "']/Description");
    }

    public boolean isFilterStartUser() {
        String arr = this.getExtendedAttribute("FilterStartUser");
        return arr.equalsIgnoreCase("true");
    }

    public boolean isFilterStartGroup() {
        String arr = this.getExtendedAttribute("FilterStartGroup");
        return arr.equalsIgnoreCase("true");
    }

    public boolean isFilterTransferGroup() {
        String arr = this.getExtendedAttribute("FilterTransferGroup");
        return arr.equalsIgnoreCase("true");
    }

    public boolean isFilterTransferPerformer() {
        String arr = this.getExtendedAttribute("FilterTransferPerformer");
        return arr.equalsIgnoreCase("true");
    }

    public boolean isFilterRegionCode() {
        String arr = this.getExtendedAttribute("FilterRegionCode");
        return arr.equalsIgnoreCase("true");
    }

    public boolean isFilterDistrictCode() {
        String arr = this.getExtendedAttribute("FilterDistrictCode");
        return arr.equalsIgnoreCase("true");
    }

    public String getFilterInfo() {
        String str = this.getExtendedAttribute(FILTERINFO);
        return str;
    }

    public String getTurnInfoUrl() {
        String str = this.getExtendedAttribute(TURNINFOURL);
        return str;
    }

    public boolean isFilterStartRegionCode() {
        String arr = this.getExtendedAttribute("FilterStartRegionCode");
        return arr.equalsIgnoreCase("true");
    }

    public String getEnabledNextWorkflow() {
        String str = this.getExtendedAttribute(ENABLEDNEXTWORKFLOW);
        return str;
    }

    public String getAutoLock() {
        String str = this.getExtendedAttribute(AUTOLOCK);
        return str;
    }

    public List<PerformerTaskModel> getPerformerModelList() {
        return this.performerModelList;
    }

    public void setPerformerModelList(List<PerformerTaskModel> performerModelList) {
        this.performerModelList = performerModelList;
    }

    public int getCooperState() {
        return this.CooperState;
    }

    public void setCooperState(int cooperState) {
        this.CooperState = cooperState;
    }

    public String getCooperRootId() {
        return this.cooperRootId;
    }

    public void setCooperRootId(String cooperRootId) {
        this.cooperRootId = cooperRootId;
    }

    public boolean isWaitAllUsers() {
        return this.waitAllUsers;
    }

    public void setWaitAllUsers(boolean waitAllUsers) {
        this.waitAllUsers = waitAllUsers;
    }

    public boolean isRequiredOpinion() {
        return this.requiredOpinion;
    }

    public void setRequiredOpinion(boolean requiredOpinion) {
        this.requiredOpinion = requiredOpinion;
    }

    public String getResources() {
        Node node = this.activityNode.selectSingleNode("Resources");
        Element ele = (Element)node;
        Iterator iterRes = ele.elementIterator("Resource");
        while (iterRes.hasNext()) {
            Element eleRes = (Element)iterRes.next();
            if (!eleRes.valueOf("@Visible").equalsIgnoreCase("false")) continue;
            ele.remove(eleRes);
        }
        return node.asXML();
    }

    public Node getResourcesNode() {
        Node node = this.activityNode.selectSingleNode("Resources");
        return node;
    }

    public String getDefineId() {
        return this.defineId;
    }

    public void setDefineId(String defineId) {
        this.defineId = defineId;
    }

    public boolean isMutiSelect() {
        return this.mutiSelect;
    }

    public String getDefaultSelectName() {
        return this.defaultSelectName;
    }

    public void setMutiSelect(boolean mutiSelect) {
        this.mutiSelect = mutiSelect;
    }

    public boolean isSendSMS() {
        return this.sendSMS;
    }

    public void setSendSMS(boolean sendSMS) {
        this.sendSMS = sendSMS;
    }

    public String getActivityDefineName() {
        return this.activityNode.valueOf("@Name");
    }

    public boolean isCanFinish() {
        return this.canFinish;
    }

    public void setCanFinish(boolean canFinish) {
        this.canFinish = canFinish;
    }

    public boolean isSpecialFinish() {
        return this.specialFinish;
    }

    public void setSpecialFinish(boolean specialFinish) {
        this.specialFinish = specialFinish;
    }

    public boolean isQuickTurn() {
        return this.quickTurn;
    }

    public void setQuickTurn(boolean quickTurn) {
        this.quickTurn = quickTurn;
    }

    public boolean isCanDelOthers() {
        return this.canDelOthers;
    }

    public boolean isWaitAllActivitysFinish() {
        return this.waitAllActivitysFinish;
    }

    public void setWaitAllActivitysFinish(boolean waitAllActivitysFinish) {
        this.waitAllActivitysFinish = waitAllActivitysFinish;
    }

    public boolean isSelectAll() {
        return this.selectAll;
    }

    public void setSelectAll(boolean selectAll) {
        this.selectAll = selectAll;
    }

    public SubProcessModel getSubProcess() {
        return this.subProcess;
    }

    public void setSubProcess(SubProcessModel subProcess) {
        this.subProcess = subProcess;
    }
}

