package com.gtis.plat.wf.model;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.dom4j.Node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ActivityModel implements Serializable {

    private static final long serialVersionUID = -3552168065400002455L;

    private static final Log log = LogFactory.getLog(ActivityModel.class);

    /**
     * 活动Id
     */
    private String defineId;
    /**
     * 活动信息xml
     */
    private Node activityNode;
    /**
     * 是否允许办结
     */
    private boolean canFinish = false;
    /**
     * 是否为多选择
     */
    private boolean mutiSelect = false;
    /**
     * 在多选的的情况下，是否出现“全部”选项
     */
    private boolean selectAll = true;
    /**
     * 是否等待其他人一起办理完毕
     */
    private boolean waitAllUsers = false;
    /**
     * 是否特殊办结
     */
    private boolean specialFinish = false;
    /**
     * 是否发送短信
     */
    private boolean sendSMS = false;
    /**
     * 快速转发
     */
    private boolean quickTurn = false;
    /**
     * 默认意见
     */
    private boolean requiredOpinion = false;
    /**
     * 是否存在协办，以及是否强行协办 1代表存在协办，不强行办理 2代表存在协办，且强行办理 -1代表不存在协办
     */
    private int CooperState = -1;
    /**
     * 协办跟活动
     */
    private String cooperRootId;
    /**
     * 默认选择的下个活动
     */
    private String defaultSelectName;
    /**
     * 过滤信息
     */
    private String filterInfo;
    /**
     * 用户Url
     */
    private String filterUrl;

    /**
     * 是否取件
     */
    private boolean canDelOthers = false;

    /**
     * 子流程
     */
    private SubProcessModel subProcess;


    private final static String BACKOPTION = "BackOption";
    /**
     * 责任部门Id
     */
    private final static String ORGANID = "OrganId";
    /**
     * 默认选择的下个活动
     */
    private final static String DEFAULTSELECTNEXTNAME = "DefaultSelectNextNodeName";
    /**
     * 意见必填
     */
    private final static String REQUIREDOPINION = "RequiredOpinion";
    /**
     * 过滤信息
     */
    private final static String FILTERINFO = "FilterInfo";
    /**
     * 过滤url
     */
    private final static String TURNINFOURL = "TurnInfoUrl";
    /**
     * 发送短信
     */
    private final static String SENDSMS = "SendSMS";
    /**
     * 特殊结束
     */
    private final static String SPECIALFINISH = "SpecialFinish";
    /**
     * 快速转发
     */
    private final static String QUICKTURN = "QuickTurn";
    private final static String CANDElOTHERS = "CanDelOthers";


    /**
     * 工作流办结时，可自动启动的下一个工作流
     */
    private final static String ENABLEDNEXTWORKFLOW = "EnabledNextWorkflow";

    /**
     * 自动挂起
     */
    private final static String AUTOLOCK="AutoLock";

    private List<PerformerTaskModel> performerModelList;
    /**
     * 风险点列表
     */
    private List<RiskModel> riskModelList;

    /**
       * 是否等待父节点所有的办结完毕
       */
    private boolean waitAllActivitysFinish = false;


    public ActivityModel(Node aNode) {
        this.activityNode = aNode;
        this.riskModelList = getRiskModelList();
        defineId = activityNode.valueOf("@Id");
        if (this.getExtendedAttribute("CanFinish").equalsIgnoreCase("true"))
            canFinish = true;
        if (this.getExtendedAttribute(CANDElOTHERS).equalsIgnoreCase("true"))
            canDelOthers = true;

        if (this.getExtendedAttribute("MutiSelect").equalsIgnoreCase("true"))
            mutiSelect = true;

        if (this.getExtendedAttribute("SelectAll").equalsIgnoreCase("false"))
            selectAll = false;


        if (this.getExtendedAttribute("WaitAllUsers").equalsIgnoreCase("true"))
            waitAllUsers = true;
        if (this.getExtendedAttribute(REQUIREDOPINION).equalsIgnoreCase("true"))
            requiredOpinion = true;
        if (this.getExtendedAttribute(SENDSMS).equalsIgnoreCase("true"))
            sendSMS = true;
        if (this.getExtendedAttribute(SPECIALFINISH).equalsIgnoreCase("true"))
            specialFinish = true;
        if (this.getExtendedAttribute(QUICKTURN).equalsIgnoreCase("true"))
            quickTurn = true;
        //if (this.getExtendedAttribute("DefaultSelected").equalsIgnoreCase("false"))
        //defaultSelected = false;
        if (this.getExtendedAttribute("COOPERATION").equals("1"))
            CooperState = 1;
        else if (this.getExtendedAttribute("COOPERATION").equals("2"))
            CooperState = 2;
        //协办根活动
        cooperRootId = this.getExtendedAttribute("COOPERROOTID");
        //默认选择的下个活动
        defaultSelectName = this.getExtendedAttribute(DEFAULTSELECTNEXTNAME);
        if (this.getExtendedAttribute("WaitAllActivitysFinish").equalsIgnoreCase("true"))
            waitAllActivitysFinish = true;

        //子流程
        Node subFlowNode = activityNode.selectSingleNode("SubFlow");
        if (subFlowNode != null && StringUtils.isNotBlank(subFlowNode.valueOf("@Id"))) {
            this.subProcess=new SubProcessModel(subFlowNode);
        }

    }

    public String getExtendedAttribute(String aName) {
        Node tmpNode = activityNode
                .selectSingleNode("ExtendedAttributes/ExtendedAttribute[@Name='"
                        + aName + "']");
        if (tmpNode != null) {
            return tmpNode.valueOf("@Value");
        } else {
            return "";
        }
    }

    public List<TransitionModel> getTransitionsList() {
        Element activityEle = (Element) activityNode;
        List<TransitionModel> lstResult = new ArrayList<TransitionModel>();
        List<Node> lstNodes = activityEle
                .selectNodes("//Transitions/Transition[@From='" + defineId
                        + "']");
        for (int i = 0; i < lstNodes.size(); i++) {
            lstResult.add(new TransitionModel(lstNodes.get(i)));
        }
        return lstResult;
    }

    public List<RiskModel> getRiskModelList() {
        Element activityEle = (Element) activityNode;
        List<RiskModel> riskModels = new ArrayList<RiskModel>();
        List<Node> lstNodes = activityEle.selectNodes("Risks/Risk");
        for (int i = 0; i < lstNodes.size(); i++) {
            riskModels.add(new RiskModel(lstNodes.get(i)));
        }
        return riskModels;
    }

    /**
     * 获取退回字符串
     *
     * @return
     */
    public String getBackTransitions() {
        return getExtendedAttribute(BACKOPTION);
    }

    /**
     * 获取责部门
     */
    public String getOrganId() {
        return getExtendedAttribute(ORGANID);
    }

    /**
     * 获得是否必填
     *
     * @return
     */
    public String getIsRequiredOpinion() {
        return getExtendedAttribute(REQUIREDOPINION);
    }

    /**
     * 获得是否发送短信
     *
     * @return
     */
    public String getIsSendSMS() {
        return getExtendedAttribute(SENDSMS);
    }

    public List<String> getFormActivitys() {
        Element activityEle = (Element) activityNode;
        List<String> lstActivitys = new ArrayList<String>();
        List<Node> lstNodes = activityEle.selectNodes("//Transitions/Transition[@To='" + defineId
                + "']");
        for (Node tmpNode : lstNodes) {
            lstActivitys.add(tmpNode.valueOf("@From"));
        }
        return lstActivitys;
    }

    public List<String> getBackTransitionsList() {
        List<String> lstResult = new ArrayList<String>();
        String backOption = getExtendedAttribute("BackOption");
        if (backOption.equalsIgnoreCase("default")) { // 上一个活动
            Element activityEle = (Element) activityNode;

            List<Node> lstNodes = activityEle
                    .selectNodes("//Transitions/Transition[@To='" + defineId
                            + "']");
            for (int i = 0; i < lstNodes.size(); i++) {
                Node transitionNode = lstNodes.get(i);
                lstResult.add(transitionNode.valueOf("@From"));
            }
        } else if (backOption.equalsIgnoreCase("NOTALLOWED")) {
            return lstResult;
        } else {
            String[] arrayOption = backOption.split(",");
            for (int i = 0; i < arrayOption.length; i++) {
                lstResult.add(arrayOption[i]);
            }
        }
        return lstResult;
    }

    public String getPriority() {
        if (activityNode != null) {
            Node tmpNode = activityNode.selectSingleNode("Priority");
            return tmpNode.getText();
        }
        return "";
    }

    public String getLimit() {
        if (activityNode != null) {
            Node tmpNode = activityNode.selectSingleNode("Limit");
            if (tmpNode.getText() != null && !tmpNode.getText().equals("")) {
                return tmpNode.getText();
            }
        }
        return "0";
    }

    /**
     * 获取该活动向后转发的类型：AND OR
     *
     * @return
     */
    public String getSplitType() {
        if (activityNode != null) {
            Node nodeTemp = activityNode
                    .selectSingleNode("TransitionRestrictions/TransitionRestriction/Split");
            if (nodeTemp != null) {
                if (nodeTemp.valueOf("@Type") != null)
                    return nodeTemp.valueOf("@Type");
            }
        }
        return "";
    }

    /**
     * 该活动的聚合类型
     *
     * @return
     */
    public String getJoinType() {
        if (activityNode != null) {
            Node nodeTemp = activityNode
                    .selectSingleNode("TransitionRestrictions/TransitionRestriction/Join");
            if (nodeTemp != null) {
                if (nodeTemp.valueOf("@Type") != null)
                    return nodeTemp.valueOf("@Type");
            }
        }
        return "";
    }

    public List<PerformerModel> getPerformerList() {
        List<PerformerModel> lstUsers = new ArrayList<PerformerModel>();
        if (activityNode != null) {
            List<Node> lstNodes = activityNode.selectNodes("Performer/User");
            for (Iterator<Node> i = lstNodes.iterator(); i.hasNext(); ) {
                lstUsers.add(new PerformerModel(i.next()));
            }
        }
        return lstUsers;
    }

    public List<ResourceModel> getResourceList() {
        List<ResourceModel> lstRes = new ArrayList<ResourceModel>();
        if (activityNode != null) {
            List<Node> lstNodes = activityNode
                    .selectNodes("Resources/Resource");
            for (Iterator<Node> i = lstNodes.iterator(); i.hasNext(); ) {
                lstRes.add(new ResourceModel(i.next()));
            }
        }
        return lstRes;
    }

    public String getActivityDescription() {
        return activityNode.valueOf("//Activity[@Id='" + defineId + "']/Description");
    }

    /**
     * 是否是当前活动的参与者，必须就是首节点活动的创建者
     *
     * @return
     */
    public boolean isFilterStartUser() {
        String arr = getExtendedAttribute("FilterStartUser");
        if (arr.equalsIgnoreCase("true")) {
            return true;
        }
        return false;
    }

    /**
     * 当前活动的参与者是否是和创建者在一个部门
     *
     * @return
     */
    public boolean isFilterStartGroup() {
        String arr = getExtendedAttribute("FilterStartGroup");
        if (arr.equalsIgnoreCase("true")) {
            return true;
        }
        return false;
    }

    /**
     * 当前活动的参与者是否和前一个节点活动的转发者在一个部门
     *
     * @return
     */
    public boolean isFilterTransferGroup() {
        String arr = getExtendedAttribute("FilterTransferGroup");
        if (arr.equalsIgnoreCase("true")) {
            return true;
        }
        return false;
    }

    /**
     * 当前活动的参与者，必须根据前一个节点活动的转发者在一个转发部门或角色
     * 如果该人属于多个部门以PF_ASSIGNMENT中的 PERFORMER_ID为准
     *
     * @return
     */
    public boolean isFilterTransferPerformer() {
        String arr = getExtendedAttribute("FilterTransferPerformer");
        if (arr.equalsIgnoreCase("true")) {
            return true;
        }
        return false;
    }

    /**
     * 是否根据行政区代码过滤人员，按照工作流实例中得regioncode过滤
     *
     * @return
     */
    public boolean isFilterRegionCode() {
        String arr = getExtendedAttribute("FilterRegionCode");
        if (arr.equalsIgnoreCase("true")) {
            return true;
        }
        return false;
    }

    /**
     * 根据工作流实例的DistrictCode，即所属地区代码进行过滤
     * @return
     */
    public boolean isFilterDistrictCode() {
        String arr = getExtendedAttribute("FilterDistrictCode");
        if (arr.equalsIgnoreCase("true")) {
            return true;
        }
        return false;
    }

    /**
     * 获得过滤信息
     *
     * @return
     */
    public String getFilterInfo() {
        String str = getExtendedAttribute(FILTERINFO);
        return str;
    }

    /**
     * 获得过滤信息
     *
     * @return
     */
    public String getTurnInfoUrl() {
        String str = getExtendedAttribute(TURNINFOURL);
        return str;
    }

    /**
     * 当前活动的参与者，是否和首节点活动的创建者属于在一个区域中
     *
     * @return
     */
    public boolean isFilterStartRegionCode() {
        String arr = getExtendedAttribute("FilterStartRegionCode");
        if (arr.equalsIgnoreCase("true")) {
            return true;
        }
        return false;
    }

    /**
     * 工作流办结时，可自动启动的下一个工作流
     * @return
     */
    public String getEnabledNextWorkflow() {
        String str = getExtendedAttribute(ENABLEDNEXTWORKFLOW);
        return str;
    }

    /**
     * 自动挂起
     * @return
     */
    public String getAutoLock(){
        String str = getExtendedAttribute(AUTOLOCK);
        return str;
    }

    ///**
    // * 获得工作流节点
    // *
    // * @param defineid
    // * @param xpdlstr
    // * @return
    // */
    // public static WorkflowProcess getWFP(String defineid, String xpdlstr) {
    // // 解析xpdl文档，获得初始活动
    // XMLInterfaceForJDK13 xmlparse = new XMLInterfaceForJDK13();
    // Package page = null;
    // try {
    // page = xmlparse.openPackageFromStream(xpdlstr.getBytes(), true);
    // } catch (Exception e) {
    // e.printStackTrace();
    // }
    //
    // WorkflowProcess wfp = page.getWorkflowProcess(defineid);
    //
    // return wfp;
    // }
    //
    // public static WfActivityXml getWfActivityXml(String acdefineid,
    // String defineid, String xpdlstr) {
    // // 根据xpdl创建第一个活动
    // WfActivityXml wfac = new WfActivityXml();
    //
    // // 解析xpdl文档
    // WorkflowProcess wfp = null;
    //
    // wfac.setWORKFLOW_DEFINITION_ID(defineid);
    // wfp = getWFP(defineid, xpdlstr);
    //
    // Activity activity = null;
    //
    // activity = (Activity) wfp.getActivities().getActivity(acdefineid);
    //
    // wfac.setTransitionres(activity.getTransitionRestrictions());
    //
    // // 获得转发类型
    // wfac.setTrantype(getTransitionType(
    // activity.getTransitionRestrictions(), true));
    //
    // WfOrganRoleUser[] wfusers = new WfOrganRoleUser[activity.getPerformer()
    // .size()];
    //
    // for (int i = 0; i < activity.getPerformer().size(); i++) {
    // User user = (User) activity.getPerformer().get(i);
    // WfOrganRoleUser wfuser = new WfOrganRoleUser();
    // wfuser.setOrganId(user.getOrganId());
    // wfuser.setRoleId(user.getRoleId());
    // wfuser.setUserId(user.getUserId());
    //
    // wfusers[i] = wfuser;
    // }
    // wfac.setPerformer(wfusers);
    //
    // // activity.getPerformer().
    // // 流程实例id
    // wfac.setACTIVITY_DEFINITION_ID(activity.getId());
    // wfac.setTIME_LIMIT(Integer.parseInt(activity.getLimit()));
    // wfac.setPRIORITY(activity.getPriority());
    //
    // wfac.setACTIVITY_NAME(activity.getName());
    //
    // return wfac;
    //
    // }
    //
    // /**
    // * 获取转发类型
    // *
    // * @param tranress
    // * @param issplit
    // * @return
    // */
    // public static String getTransitionType(TransitionRestrictions tranress,
    // boolean issplit) {
    // String type = "";
    //
    // // 获取转发关系
    // try {
    // if (tranress != null) {
    // for (int i = 0; i < tranress.size(); i++) {
    // TransitionRestriction tranres = (TransitionRestriction) tranress
    // .get(i);
    // if (issplit)
    // type = tranres.getSplit().getType();
    // else
    // type = tranres.getJoin().getType();
    // }
    // }
    // } catch (Exception e) {
    //
    // }
    //
    // return type;
    // }
    //
    // /**
    // * 获取转发类型
    // *
    // * @param activity
    // * @param issplit
    // * 1.true 发散 2.false 聚合
    // * @return 1."" 直接转发 2.xor 可选转发 3.and 并列转发
    // */
    // public static String getTransitionType(WfActivityXml activity,
    // boolean issplit) {
    // String type = "";
    //
    // // 获取转发关系
    // try {
    // if (activity.getTransitionres() != null) {
    // TransitionRestrictions tranress = activity.getTransitionres();
    // for (int i = 0; i < tranress.size(); i++) {
    // TransitionRestriction tranres = (TransitionRestriction) tranress
    // .get(i);
    // if (issplit)
    // type = tranres.getSplit().getType();
    // else
    // type = tranres.getJoin().getType();
    // }
    // }
    // } catch (Exception e) {
    // log
    // .info("没有 TransitionRestriction或者TransitionRestrictions字段，流程可能为串行流程");
    // }
    //
    // return type;
    // }
    //
    // /**
    // * 获取转发列表
    // *
    // * @param acdefineid
    // * @param defineid
    // * @param xpdlstr
    // * @param issplit
    // * @return
    // */
    // public static List<Transition> getTransitions(String acdefineid,
    // String defineid, String xpdlstr, boolean issplit) {
    // List<Transition> listtrans = new LinkedList<Transition>();
    // // 解析xpdl文档
    // WorkflowProcess wfp = null;
    // wfp = getWFP(defineid, xpdlstr);
    //
    // for (int i = 0; i < wfp.getTransitions().size(); i++) {
    // Transition transition = (Transition) wfp.getTransitions().get(i);
    // if (issplit) {
    // if (transition.getFrom().equals(acdefineid)) {
    // listtrans.add(transition);
    // }
    // } else {
    // if (transition.getTo().equals(acdefineid)) {
    // listtrans.add(transition);
    // }
    // }
    // }
    //
    // return listtrans;
    // }

    public List<PerformerTaskModel> getPerformerModelList() {
        return performerModelList;
    }

    public void setPerformerModelList(List<PerformerTaskModel> performerModelList) {
        this.performerModelList = performerModelList;
    }

    public int getCooperState() {
        return CooperState;
    }

    public void setCooperState(int cooperState) {
        CooperState = cooperState;
    }

    public String getCooperRootId() {
        return cooperRootId;
    }

    public void setCooperRootId(String cooperRootId) {
        this.cooperRootId = cooperRootId;
    }

    public boolean isWaitAllUsers() {
        return waitAllUsers;
    }

    public void setWaitAllUsers(boolean waitAllUsers) {
        this.waitAllUsers = waitAllUsers;
    }

    public boolean isRequiredOpinion() {
        return requiredOpinion;
    }

    public void setRequiredOpinion(boolean requiredOpinion) {
        this.requiredOpinion = requiredOpinion;
    }

    public String getResources() {
        Node node = activityNode.selectSingleNode("Resources");
        //去掉不可见的
        Element ele = (Element) node;
        Iterator iterRes = ele.elementIterator("Resource");

        while (iterRes.hasNext()) {
            Element eleRes = (Element) iterRes.next();
            if (eleRes.valueOf("@Visible").equalsIgnoreCase("false"))
                ele.remove(eleRes);
        }

        return node.asXML();
    }

    public Node getResourcesNode() {
        Node node = activityNode.selectSingleNode("Resources");
        return node;
    }

    public String getDefineId() {
        return defineId;
    }

    public void setDefineId(String defineId) {
        this.defineId = defineId;
    }

    public boolean isMutiSelect() {
        return mutiSelect;
    }

    public String getDefaultSelectName() {
        return defaultSelectName;
    }

    public void setMutiSelect(boolean mutiSelect) {
        this.mutiSelect = mutiSelect;
    }

    public boolean isSendSMS() {
        return sendSMS;
    }

    public void setSendSMS(boolean sendSMS) {
        this.sendSMS = sendSMS;
    }

    public String getActivityDefineName() {
        return activityNode.valueOf("@Name");
    }

    public boolean isCanFinish() {
        return canFinish;
    }

    public void setCanFinish(boolean canFinish) {
        this.canFinish = canFinish;
    }

    public boolean isSpecialFinish() {
        return specialFinish;
    }

    public void setSpecialFinish(boolean specialFinish) {
        this.specialFinish = specialFinish;
    }

    public boolean isQuickTurn() {
        return quickTurn;
    }

    public void setQuickTurn(boolean quickTurn) {
        this.quickTurn = quickTurn;
    }

    public boolean isCanDelOthers() {
        return canDelOthers;
    }

    public boolean isWaitAllActivitysFinish() {
        return waitAllActivitysFinish;
    }

    public void setWaitAllActivitysFinish(boolean waitAllActivitysFinish) {
        this.waitAllActivitysFinish = waitAllActivitysFinish;
    }


    public boolean isSelectAll() {
        return selectAll;
    }

    public void setSelectAll(boolean selectAll) {
        this.selectAll = selectAll;
    }

    public SubProcessModel getSubProcess() {
        return subProcess;
    }

    public void setSubProcess(SubProcessModel subProcess) {
        this.subProcess = subProcess;
    }
}
