/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: SessionUtils.java
 *
 * LastModified: 2009-09-23 11:02:03
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.generic.util;

import javax.servlet.http.HttpServletRequest;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-9-23
 */
public class SessionUtils {

    @SuppressWarnings("unchecked")
    public static <T> T get(HttpServletRequest request, String name) {
        return (T) request.getSession().getAttribute(name);
    }

    public static void put(HttpServletRequest request, String name, Object value) {
        request.getSession().setAttribute(name, value);
    }

    public static void remove(HttpServletRequest request, String name) {
        request.getSession().removeAttribute(name);
    }
}
