package com.gtis.dform.model.impl;

import com.gtis.dform.model.FormModel;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;

/**
 * User: jibo
 * Date: 11-9-5
 * Time: 下午2:41
 * To change this template use File | Settings | File Templates.
 */
public abstract class FormDbModel implements FormModel {
    private static final Log LOG = LogFactory.getLog(FormDbModel.class);
    static String SPLITSTR = "[SPLIT]";   //sql语句分割符号
    JdbcTemplate jdbcT;


    public JdbcTemplate getJdbcT() {
        return jdbcT;
    }

    public void setJdbcT(JdbcTemplate jdbcT) {
        this.jdbcT = jdbcT;
    }

    public String getName() {
        return null;
    }

    public Object executeCmd(String cmd) {
        cmd = cmd.trim();
        LOG.info(cmd);
        if (StringUtils.isNotBlank(cmd)) {
            if (cmd.indexOf("$") > 0) {
                LOG.error("------请检查传入参数设置或sql语句！-----/n" + cmd);
            } else {
                return executeSql(cmd);
            }
        }
        return null;
    }

    /**
     * 执行一个sql语句
     *
     * @param sql
     * @return
     */
    public abstract Object executeSql(String sql);
}
