/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.web;

import com.gtis.plat.vo.PfConfigVo;
import com.gtis.plat.vo.UserInfo;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContext;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.anonymous.AnonymousAuthenticationToken;

public class SessionUtil {
    private static final UserInfo guest = new UserInfo();

    @Deprecated
    public static UserInfo getUserInfo(HttpServletRequest request) {
        Authentication authentication;
        SecurityContext context = SecurityContextHolder.getContext();
        if (context != null && (authentication = context.getAuthentication()) != null) {
            return (UserInfo)authentication.getPrincipal();
        }
        return null;
    }

    public static UserInfo getCurrentUser() {
        Authentication authentication;
        SecurityContext context = SecurityContextHolder.getContext();
        if (context != null && (authentication = context.getAuthentication()) != null) {
            if (authentication instanceof AnonymousAuthenticationToken) {
                return guest;
            }
            return (UserInfo)authentication.getPrincipal();
        }
        return null;
    }

    public static String getCurrentUserId() {
        UserInfo user = SessionUtil.getCurrentUser();
        return user != null ? user.getId() : null;
    }

    public static String getCurrentUserIds() {
        UserInfo info = SessionUtil.getCurrentUser();
        return info.getUsersIdAll();
    }

    @Deprecated
    public static PfConfigVo getUserConfig(HttpServletRequest request) {
        UserInfo info = SessionUtil.getUserInfo(request);
        return info.getConfig();
    }

    @Deprecated
    public static String getUserId(HttpServletRequest request) {
        UserInfo info = SessionUtil.getUserInfo(request);
        if (info != null) {
            return info.getId();
        }
        return "";
    }

    @Deprecated
    public static String getUserIds(HttpServletRequest request) {
        UserInfo info = SessionUtil.getUserInfo(request);
        return info.getUsersIdAll();
    }

    @Deprecated
    public static String getUserName(HttpServletRequest request) {
        UserInfo userInfo = SessionUtil.getUserInfo(request);
        if (userInfo != null) {
            return userInfo.getUsername();
        }
        return "";
    }

    public static String getCurTime() {
        String result = "";
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat tempDate = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 ");
        result = tempDate.format(cal.getTime());
        result = result + " \u661f\u671f" + SessionUtil.getChineseDayOfWeek(cal.get(7));
        return result;
    }

    public static String getChineseDayOfWeek(int dayOfWeek) {
        switch (dayOfWeek) {
            case 2: {
                return "\u4e00";
            }
            case 3: {
                return "\u4e8c";
            }
            case 4: {
                return "\u4e09";
            }
            case 5: {
                return "\u56db";
            }
            case 6: {
                return "\u4e94";
            }
            case 7: {
                return "\u516d";
            }
            case 1: {
                return "\u65e5";
            }
        }
        return "";
    }

    static {
        guest.setAdmin(false);
        guest.setUsername("guest");
        guest.setId("guest");
    }
}

