/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.support;

import com.gtis.config.AppConfig;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jndi.JndiObjectFactoryBean;

public class JndiSupportBasicDataSource
extends BasicDataSource
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(JndiSupportBasicDataSource.class);
    private String jndiName;
    private DataSource jndiDataSource;

    public JndiSupportBasicDataSource() {
        this.setDriverClassName(AppConfig.getProperty("egov.db.driver"));
        this.setInitialSize(10);
        this.setMaxActive(80);
        this.setMinIdle(5);
        this.setMaxIdle(40);
        this.setMaxWait(2000L);
        this.setMinEvictableIdleTimeMillis(60000L);
        this.setTimeBetweenEvictionRunsMillis(30000L);
        this.setRemoveAbandoned(true);
        this.setRemoveAbandonedTimeout(120);
        this.setLogAbandoned(true);
        this.setDefaultAutoCommit(true);
        this.setTimeBetweenEvictionRunsMillis(600000L);
        this.setMinEvictableIdleTimeMillis(600000L);
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public Connection getConnection() throws SQLException {
        return this.jndiDataSource != null ? this.jndiDataSource.getConnection() : super.getConnection();
    }

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isNotBlank((String)this.jndiName)) {
            JndiObjectFactoryBean factoryBean = new JndiObjectFactoryBean();
            factoryBean.setJndiName(this.jndiName);
            try {
                factoryBean.afterPropertiesSet();
                this.jndiDataSource = (DataSource)factoryBean.getObject();
            }
            catch (NamingException e) {
                LOG.info("JNDI lookup failed,try to use local datasource,ex:[{}]", (Object)e.getMessage());
            }
        }
    }
}

