/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.generic.security;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.ui.logout.LogoutFilter;
import org.springframework.security.ui.logout.LogoutHandler;
import org.springframework.util.StringUtils;

public class EgovLogoutFilter
extends LogoutFilter {
    private String logoutSuccessUrlParameter;

    public String getLogoutSuccessUrlParameter() {
        return this.logoutSuccessUrlParameter;
    }

    public void setLogoutSuccessUrlParameter(String logoutSuccessUrlParameter) {
        this.logoutSuccessUrlParameter = logoutSuccessUrlParameter;
    }

    public EgovLogoutFilter(String logoutSuccessUrl, LogoutHandler[] handlers) {
        super(logoutSuccessUrl, handlers);
    }

    public String determineTargetUrl(HttpServletRequest request, HttpServletResponse response) {
        String targetUrl = this.getLogoutSuccessUrl();
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(request.isSecure() ? "https://" : "http://");
        urlBuilder.append(request.getServerName());
        urlBuilder.append(":");
        urlBuilder.append(request.getServerPort());
        String urlBase = urlBuilder.toString();
        if (!targetUrl.startsWith("http://") && !targetUrl.startsWith("https://")) {
            targetUrl = urlBase + targetUrl;
        }
        if (!StringUtils.hasLength((String)(targetUrl = !this.logoutSuccessUrlParameter.startsWith("http://") && !this.logoutSuccessUrlParameter.startsWith("https://") ? targetUrl + "?service=" + urlBase + this.logoutSuccessUrlParameter : targetUrl + "?service=" + this.logoutSuccessUrlParameter))) {
            targetUrl = "/";
        }
        return targetUrl;
    }
}

