/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.generic.image;

import com.gtis.generic.image.ImageTransform;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImageTransformFactory {
    public static final String defaultImageTransform = "com.gtis.generic.image.impl.AwtImageTransform";
    private static final Log log = LogFactory.getLog(ImageTransformFactory.class);
    private static Class imageTransformClazz;
    private static final Object imageTransformLock;

    public static void setTransformProvider(String className) {
        try {
            imageTransformClazz = Class.forName(className);
        }
        catch (Exception e) {
            log.error((Object)"Invalid provider class of image transforming.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageTransform getImageTransform() {
        if (imageTransformClazz == null) {
            Object object = imageTransformLock;
            synchronized (object) {
                if (imageTransformClazz == null) {
                    ImageTransformFactory.setTransformProvider(defaultImageTransform);
                }
            }
        }
        try {
            return (ImageTransform)imageTransformClazz.newInstance();
        }
        catch (Exception e) {
            log.error((Object)"instance class error", (Throwable)e);
            return null;
        }
    }

    static {
        imageTransformLock = new Object();
    }
}

