/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.config;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;

public class SM3 {
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String IV_HEX_STR = "7380166f 4914b2b9 172442d7 da8a0600 a96f30bc 163138aa e38dee4d b0fb0e4e";
    private static final BigInteger IV = new BigInteger("7380166f 4914b2b9 172442d7 da8a0600 a96f30bc 163138aa e38dee4d b0fb0e4e".replaceAll(" ", ""), 16);
    private static final Integer TJ15 = Integer.valueOf("79cc4519", 16);
    private static final Integer TJ63 = Integer.valueOf("7a879d8a", 16);
    private static final byte[] FIRST_PADDING = new byte[]{-128};
    private static final byte[] ZERO_PADDING = new byte[]{0};

    private static int t(int j) {
        if (j >= 0 && j <= 15) {
            return TJ15;
        }
        if (j >= 16 && j <= 63) {
            return TJ63;
        }
        throw new RuntimeException("data invalid");
    }

    private static Integer ff(Integer x, Integer y, Integer z, int j) {
        if (j >= 0 && j <= 15) {
            return x ^ y ^ z;
        }
        if (j >= 16 && j <= 63) {
            return x & y | x & z | y & z;
        }
        throw new RuntimeException("data invalid");
    }

    private static Integer gg(Integer x, Integer y, Integer z, int j) {
        if (j >= 0 && j <= 15) {
            return x ^ y ^ z;
        }
        if (j >= 16 && j <= 63) {
            return x & y | ~x.intValue() & z;
        }
        throw new RuntimeException("data invalid");
    }

    private static Integer p0(Integer x) {
        return x ^ Integer.rotateLeft(x, 9) ^ Integer.rotateLeft(x, 17);
    }

    private static Integer p1(Integer x) {
        return x ^ Integer.rotateLeft(x, 15) ^ Integer.rotateLeft(x, 23);
    }

    private static byte[] padding(byte[] source) throws IOException {
        long l = source.length * 8;
        long k = 448L - (l + 1L) % 512L;
        if (k < 0L) {
            k += 512L;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(source);
        baos.write(FIRST_PADDING);
        for (long i = k - 7L; i > 0L; i -= 8L) {
            baos.write(ZERO_PADDING);
        }
        baos.write(SM3.long2bytes(l));
        return baos.toByteArray();
    }

    private static byte[] long2bytes(long l) {
        byte[] bytes = new byte[8];
        for (int i = 0; i < 8; ++i) {
            bytes[i] = (byte)(l >>> (7 - i) * 8);
        }
        return bytes;
    }

    public static byte[] hash(byte[] source) throws IOException {
        byte[] m1 = SM3.padding(source);
        int n = m1.length / 64;
        byte[] vi = IV.toByteArray();
        byte[] vi1 = null;
        for (int i = 0; i < n; ++i) {
            byte[] b = Arrays.copyOfRange(m1, i * 64, (i + 1) * 64);
            vi1 = SM3.cf(vi, b);
            vi = vi1;
        }
        return vi1;
    }

    private static byte[] cf(byte[] vi, byte[] bi) throws IOException {
        int j;
        int a = SM3.toInteger(vi, 0);
        int b = SM3.toInteger(vi, 1);
        int c = SM3.toInteger(vi, 2);
        int d = SM3.toInteger(vi, 3);
        int e = SM3.toInteger(vi, 4);
        int f = SM3.toInteger(vi, 5);
        int g = SM3.toInteger(vi, 6);
        int h = SM3.toInteger(vi, 7);
        int[] w = new int[68];
        int[] w1 = new int[64];
        for (int i = 0; i < 16; ++i) {
            w[i] = SM3.toInteger(bi, i);
        }
        for (j = 16; j < 68; ++j) {
            w[j] = SM3.p1(w[j - 16] ^ w[j - 9] ^ Integer.rotateLeft(w[j - 3], 15)) ^ Integer.rotateLeft(w[j - 13], 7) ^ w[j - 6];
        }
        for (j = 0; j < 64; ++j) {
            w1[j] = w[j] ^ w[j + 4];
        }
        for (int j2 = 0; j2 < 64; ++j2) {
            int ss1 = Integer.rotateLeft(Integer.rotateLeft(a, 12) + e + Integer.rotateLeft(SM3.t(j2), j2), 7);
            int ss2 = ss1 ^ Integer.rotateLeft(a, 12);
            int tt1 = SM3.ff(a, b, c, j2) + d + ss2 + w1[j2];
            int tt2 = SM3.gg(e, f, g, j2) + h + ss1 + w[j2];
            d = c;
            c = Integer.rotateLeft(b, 9);
            b = a;
            a = tt1;
            h = g;
            g = Integer.rotateLeft(f, 19);
            f = e;
            e = SM3.p0(tt2);
        }
        byte[] v = SM3.toByteArray(a, b, c, d, e, f, g, h);
        for (int i = 0; i < v.length; ++i) {
            v[i] = (byte)(v[i] ^ vi[i]);
        }
        return v;
    }

    private static int toInteger(byte[] source, int index) {
        StringBuilder valueStr = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            valueStr.append(hexDigits[(byte)((source[index * 4 + i] & 0xF0) >> 4)]);
            valueStr.append(hexDigits[(byte)(source[index * 4 + i] & 0xF)]);
        }
        return Long.valueOf(valueStr.toString(), 16).intValue();
    }

    private static byte[] toByteArray(int a, int b, int c, int d, int e, int f, int g, int h) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(32);
        baos.write(SM3.toByteArray(a));
        baos.write(SM3.toByteArray(b));
        baos.write(SM3.toByteArray(c));
        baos.write(SM3.toByteArray(d));
        baos.write(SM3.toByteArray(e));
        baos.write(SM3.toByteArray(f));
        baos.write(SM3.toByteArray(g));
        baos.write(SM3.toByteArray(h));
        return baos.toByteArray();
    }

    public static byte[] toByteArray(int i) {
        byte[] byteArray = new byte[]{(byte)(i >>> 24), (byte)((i & 0xFFFFFF) >>> 16), (byte)((i & 0xFFFF) >>> 8), (byte)(i & 0xFF)};
        return byteArray;
    }

    private static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return "" + hexDigits[d1] + hexDigits[d2];
    }

    public static String byteArrayToHexString(byte[] b) {
        StringBuilder resultSb = new StringBuilder();
        for (byte value : b) {
            resultSb.append(SM3.byteToHexString(value));
        }
        return resultSb.toString();
    }

    public static void main(String[] args) throws IOException {
        System.out.println(SM3.byteArrayToHexString(SM3.hash("test sm3 hash".getBytes())));
    }
}

