/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.config;

import com.gtis.config.SM3;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.encoders.Hex;

public class SM2Utils {
    private static BigInteger n = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
    private static BigInteger p = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
    private static BigInteger a = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
    private static BigInteger b = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
    private static BigInteger gx = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
    private static BigInteger gy = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
    private static ECDomainParameters ecc_bc_spec;
    private static final int DIGEST_LENGTH = 32;
    private static SecureRandom random;
    private static ECCurve.Fp curve;
    private static ECPoint G;
    private static final String PUBLIC_KEY = "PUBLIC_KEY";
    private static final String PRIVATE_KEY = "PRIVATE_KEY";

    private static Map<String, Object> generateKeyPairMap() {
        HashMap<String, Object> keyMap = new HashMap<String, Object>(4);
        BigInteger privateKey = SM2Utils.random(n.subtract(new BigInteger("1")));
        ECPoint publicKey = G.multiply(privateKey).normalize();
        if (SM2Utils.checkPublicKey(publicKey)) {
            keyMap.put(PUBLIC_KEY, publicKey);
            keyMap.put(PRIVATE_KEY, privateKey);
            return keyMap;
        }
        return null;
    }

    private static String getPublicKey(Map<String, Object> keyMap) {
        ECPoint publicKey = (ECPoint)keyMap.get(PUBLIC_KEY);
        byte[] keyEncoded = publicKey.getEncoded(true);
        return SM2Utils.encryptBase64(keyEncoded);
    }

    private static String getPrivateKey(Map<String, Object> keyMap) {
        BigInteger privateKey = (BigInteger)keyMap.get(PRIVATE_KEY);
        byte[] keyEncoded = privateKey.toByteArray();
        return SM2Utils.encryptBase64(keyEncoded);
    }

    public static String encrypt(String input, String publicKey) {
        byte[] keyByte = SM2Utils.decryptBase64(publicKey);
        ECPoint point = curve.decodePoint(keyByte);
        byte[] encrypt = SM2Utils.encrypt(input, point);
        return Hex.toHexString((byte[])encrypt);
    }

    private static byte[] encrypt(String input, ECPoint publicKey) {
        byte[] c1Buffer;
        BigInteger k;
        ECPoint kpb;
        byte[] kpbBytes;
        byte[] t;
        byte[] inputBuffer = new byte[]{};
        try {
            inputBuffer = input.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        do {
            ECPoint s;
            k = SM2Utils.random(n);
            ECPoint c1 = G.multiply(k);
            c1Buffer = c1.getEncoded(false);
            BigInteger h = ecc_bc_spec.getH();
            if (h == null || !(s = publicKey.multiply(h)).isInfinity()) continue;
            throw new IllegalStateException();
        } while (SM2Utils.allZero(t = SM2Utils.kdf(kpbBytes = (kpb = publicKey.multiply(k).normalize()).getEncoded(false), inputBuffer.length)));
        byte[] c2 = new byte[inputBuffer.length];
        for (int i = 0; i < inputBuffer.length; ++i) {
            c2[i] = (byte)(inputBuffer[i] ^ t[i]);
        }
        byte[] c3 = SM2Utils.sm3hash(kpb.getXCoord().toBigInteger().toByteArray(), inputBuffer, kpb.getYCoord().toBigInteger().toByteArray());
        byte[] encryptResult = new byte[c1Buffer.length + c2.length + c3.length];
        System.arraycopy(c1Buffer, 0, encryptResult, 0, c1Buffer.length);
        System.arraycopy(c2, 0, encryptResult, c1Buffer.length, c2.length);
        System.arraycopy(c3, 0, encryptResult, c1Buffer.length + c2.length, c3.length);
        return encryptResult;
    }

    public static String decrypt(String input, String privateKeyStr) {
        byte[] keyByte = SM2Utils.decryptBase64(privateKeyStr);
        BigInteger privateKey = new BigInteger(keyByte);
        byte[] enStr = Hex.decode((String)input);
        return SM2Utils.decrypt(enStr, privateKey);
    }

    private static String decrypt(byte[] encryptData, BigInteger privateKey) {
        int klen;
        ECPoint s;
        byte[] c1Byte = new byte[65];
        System.arraycopy(encryptData, 0, c1Byte, 0, c1Byte.length);
        ECPoint c1 = curve.decodePoint(c1Byte).normalize();
        BigInteger h = ecc_bc_spec.getH();
        if (h != null && (s = c1.multiply(h)).isInfinity()) {
            throw new IllegalStateException();
        }
        ECPoint dBC1 = c1.multiply(privateKey).normalize();
        byte[] dBC1Bytes = dBC1.getEncoded(false);
        byte[] t = SM2Utils.kdf(dBC1Bytes, klen = encryptData.length - 65 - 32);
        if (SM2Utils.allZero(t)) {
            System.err.println("all zero");
            throw new IllegalStateException();
        }
        byte[] M = new byte[klen];
        for (int i = 0; i < M.length; ++i) {
            M[i] = (byte)(encryptData[c1Byte.length + i] ^ t[i]);
        }
        byte[] C3 = new byte[32];
        System.arraycopy(encryptData, encryptData.length - 32, C3, 0, 32);
        byte[] u = SM2Utils.sm3hash(dBC1.getXCoord().toBigInteger().toByteArray(), M, dBC1.getYCoord().toBigInteger().toByteArray());
        if (Arrays.equals(u, C3)) {
            System.out.println("\u89e3\u5bc6\u6210\u529f");
            return new String(M, StandardCharsets.UTF_8);
        }
        System.out.println("\u89e3\u5bc6\u9a8c\u8bc1\u5931\u8d25");
        return null;
    }

    private static boolean between(BigInteger param, BigInteger min, BigInteger max) {
        return param.compareTo(min) >= 0 && param.compareTo(max) < 0;
    }

    private static boolean checkPublicKey(ECPoint publicKey) {
        if (!publicKey.isInfinity()) {
            BigInteger x = publicKey.getXCoord().toBigInteger();
            BigInteger y = publicKey.getYCoord().toBigInteger();
            if (SM2Utils.between(x, new BigInteger("0"), p) && SM2Utils.between(y, new BigInteger("0"), p)) {
                BigInteger xResult = x.pow(3).add(a.multiply(x)).add(b).mod(p);
                BigInteger yResult = y.pow(2).mod(p);
                return yResult.equals(xResult) && publicKey.multiply(n).isInfinity();
            }
        }
        return false;
    }

    private static byte[] join(byte[] ... params) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] res = null;
        try {
            for (byte[] param : params) {
                baos.write(param);
            }
            res = baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    private static byte[] sm3hash(byte[] ... params) {
        byte[] res = null;
        try {
            res = SM3.hash(SM2Utils.join(params));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    private static byte[] ZA(String IDA, ECPoint aPublicKey) {
        byte[] idaBytes = IDA.getBytes();
        int entlenA = idaBytes.length * 8;
        byte[] entla = new byte[]{(byte)(entlenA & 0xFF00), (byte)(entlenA & 0xFF)};
        return SM2Utils.sm3hash(entla, idaBytes, a.toByteArray(), b.toByteArray(), gx.toByteArray(), gy.toByteArray(), aPublicKey.getXCoord().toBigInteger().toByteArray(), aPublicKey.getYCoord().toBigInteger().toByteArray());
    }

    public static String sign(String data, String signFlag, String publicKeyStr, String privateKeyStr) {
        byte[] dePublicKey = SM2Utils.decryptBase64(publicKeyStr);
        ECPoint publicKey = curve.decodePoint(dePublicKey);
        byte[] dePrivateKey = SM2Utils.decryptBase64(privateKeyStr);
        BigInteger privateKey = new BigInteger(dePrivateKey);
        return SM2Utils.sign(data, signFlag, publicKey, privateKey);
    }

    private static String sign(String M, String signFlag, ECPoint publicKey, BigInteger privateKey) {
        BigInteger k;
        BigInteger r;
        byte[] ZA = SM2Utils.ZA(signFlag, publicKey);
        byte[] M_ = SM2Utils.join(ZA, M.getBytes());
        BigInteger e = new BigInteger(1, SM2Utils.sm3hash(new byte[][]{M_}));
        do {
            k = SM2Utils.random(n);
            ECPoint p1 = G.multiply(k).normalize();
            BigInteger x1 = p1.getXCoord().toBigInteger();
            r = e.add(x1);
        } while ((r = r.mod(n)).equals(BigInteger.ZERO) || r.add(k).equals(n));
        BigInteger s = privateKey.add(BigInteger.ONE).modInverse(n).multiply(k.subtract(r.multiply(privateKey)).mod(n)).mod(n);
        byte[] rBytes = r.toByteArray();
        byte[] sBytes = s.toByteArray();
        String rBase64String = SM2Utils.encryptBase64(rBytes);
        String sBase64String = SM2Utils.encryptBase64(sBytes);
        return rBase64String + "," + sBase64String;
    }

    public static boolean verify(String data, String signature, String signFlag, String publicKey) {
        byte[] dePublicKey = SM2Utils.decryptBase64(publicKey);
        ECPoint aPublicKey = curve.decodePoint(dePublicKey);
        String[] signParts = signature.split(",");
        if (signParts.length < 2) {
            return false;
        }
        String rPart = signParts[0];
        String sPart = signParts[1];
        BigInteger r = new BigInteger(SM2Utils.decryptBase64(rPart));
        BigInteger s = new BigInteger(SM2Utils.decryptBase64(sPart));
        if (!SM2Utils.between(r, BigInteger.ONE, n)) {
            return false;
        }
        if (!SM2Utils.between(s, BigInteger.ONE, n)) {
            return false;
        }
        byte[] M_ = SM2Utils.join(SM2Utils.ZA(signFlag, aPublicKey), data.getBytes());
        BigInteger e = new BigInteger(1, SM2Utils.sm3hash(new byte[][]{M_}));
        BigInteger t = r.add(s).mod(n);
        if (t.equals(BigInteger.ZERO)) {
            return false;
        }
        ECPoint p1 = G.multiply(s).normalize();
        ECPoint p2 = aPublicKey.multiply(t).normalize();
        BigInteger x1 = p1.add(p2).normalize().getXCoord().toBigInteger();
        BigInteger R = e.add(x1).mod(n);
        return R.equals(r);
    }

    private static byte[] kdf(byte[] Z, int klen) {
        int ct = 1;
        int end = (int)Math.ceil((double)klen * 1.0 / 32.0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            for (int i = 1; i < end; ++i) {
                baos.write(SM2Utils.sm3hash(Z, SM3.toByteArray(ct)));
                ++ct;
            }
            byte[] last = SM2Utils.sm3hash(Z, SM3.toByteArray(ct));
            if (klen % 32 == 0) {
                baos.write(last);
            } else {
                baos.write(last, 0, klen % 32);
            }
            return baos.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String encryptBase64(byte[] key) {
        return new String(Base64.encodeBase64((byte[])key), StandardCharsets.UTF_8);
    }

    private static byte[] decryptBase64(String key) {
        try {
            return Base64.decodeBase64((byte[])key.getBytes(StandardCharsets.UTF_8));
        }
        catch (IllegalArgumentException e) {
            byte[] bytes;
            try {
                bytes = Base64.decodeBase64((byte[])key.getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception e1) {
                throw new RuntimeException(key + " Base64.getMimeDecoder()\u89e3\u7801\u5931\u8d25", e1);
            }
            if (null == bytes || bytes.length == 0) {
                throw new RuntimeException(key + " Base64.getMimeDecoder()\u89e3\u7801\u5931\u8d25,\u8fd4\u56de\u7a7a\u4e32");
            }
            return bytes;
        }
    }

    private static BigInteger random(BigInteger max) {
        BigInteger r = new BigInteger(256, random);
        while (r.compareTo(max) >= 0) {
            r = new BigInteger(128, random);
        }
        return r;
    }

    private static boolean allZero(byte[] buffer) {
        if (null == buffer || buffer.length == 0) {
            throw new RuntimeException("\u76ee\u6807\u6570\u7ec4\u4e3a\u7a7a");
        }
        for (byte value : buffer) {
            if (value == 0) continue;
            return false;
        }
        return true;
    }

    private static String changeCharSet(String str, String newCharset) throws UnsupportedEncodingException {
        if (str != null) {
            byte[] bs = str.getBytes();
            return new String(bs, newCharset);
        }
        return str;
    }

    public static String toUTF8(String str) {
        String result = str;
        try {
            result = SM2Utils.changeCharSet(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        System.out.println("-----------------\u516c\u94a5\u52a0\u5bc6\u4e0e\u89e3\u5bc6-----------------");
        String publicKey = "AxqpB18lhRv/SlPBCKhVBY1Rsw/XLwUcwLsPDwOk53K1";
        String privateKey = "ALF/tYDarqq0gcZ+1ZiHJ2at7UYaZkUzCM3qZEwAkZto";
        String publicKey_request = "AlLQTp69g6972MpXWqNjJZqYqqEs7oQIV7CBgeXTx+Ar";
        System.out.println("\u516c\u94a5:" + publicKey);
        System.out.println("\u79c1\u94a5:" + privateKey);
        System.out.println("\u52a0\u5bc6\u7684\u516c\u94a5\uff1a" + publicKey_request);
        System.out.println("------------\u8bf7\u6c42\u53c2\u6570\u52a0\u5bc6--------------");
        String encrypt = SM2Utils.encrypt("{\n\t\"sendSeqNo\": \"2021073001161788003801339\",\n\t\"sendDate\": \"20210730\",\n\t\"sendTime\": \"231559\",\n\t\"operNo\": \"zhangsan\",\n\t\"data\": {\n\t\t\"esfmmhth\": \"\u6e2d\u97e9\u57ce\uff082021\uff0907\u4e700552\",\n\t\t\"sfzjhm \": \"\",\n        \"qxdm\": \"610528\"\n\t}\n}", publicKey_request);
        System.out.println("\u5bc6\u6587:" + encrypt);
        encrypt = "04bc83d4f56a72d42304545dccf5cd222447c3a938e91aeb4857a427312a77183ef286dd824f83d58ca07b7f3006ea40f1a7d76712d481e7610777c8495bc2913590eb131adbe15f17c65908bb7c084386d792ac9b3653609f1e2a20e1903c8cc8856bdebd2fd6dedf7cec30289f0c0234b409df1e0bb5a99ae65375709098965604c759136c2481b7d9c2c15d1c1571f6c5d7c2b4162dd37c9d89a0704641bf9c34a1d1a2d89c5d0a1716aaab78de292f538de771120faccc18303f93cb945906e9f15d920429307fa796e7dc8c9f37c4eae580a34c86c22dad75153c58404065287c48d2a261f1daaf14e9da3826f6b57bf76b4001f223b275b6e839420799bb0fef2527e8b72be0831dcebaf9b8476d806b8f07ab10babc548c308d639d2351b5a63213f8ef1ad07cf0bccdb4b8c6a422e449e233e6f800da6ed4ec9614e3855de675cb81cc8e32ce1d53c33abe831333e132a308960bf6a9c9101e01f6561fc067cb55d2dbf902e0c87f68a68bd6783017b067599fcd5c209ce7232c6bb137c30130f2e5cfcc82fcb97066dd186c54f50bc2ff4cdcbd03b8680d842727a3b80d8f59b871f9ef5b2fc52b0f39dfb517ce19e2fe750737a353b95b3e15ad31f396e4f238091e7c1aa4ec48def16b4b6422159c5218ce30c7c69809c573e48e474e6ea77765b9850191ebfd5ecae0e6319e31d675731a5bdfcb01ec1eade293268ce5054cc98064b802a25c850c5f5e50f89e1677dcfe767f00c165cd5c2ff3568a6ad3c59ba17cdab431676a1fb792f6916e83175e2d5f81a0207ba20acb0d64c6ee8071ae33d679958f11fe0c5ff293df917a1fb0cab15b512164e6d3e704374132cc0ec2652880cfbe62e9a1418518c852a513e0a9a6dff34068e34d6a41274e01b528303331ca82e4786ae0e2a16e8fa309b678976e6aef5e95d90055b312faffd23f08e30f8a27ce3a4c5671fe02091c85d18f4337340f8ca483b9228e12d9dacb80f135cd66487762b7a1287a229f4b5589c999f70660038b07e34ba499c5211493dbdc76145af338239fd530f66e0bc38dfbfbb25364";
        String value = SM2Utils.decrypt(encrypt, privateKey);
        value = URLDecoder.decode(value, StandardCharsets.UTF_8.name());
        System.out.println("\u89e3\u5bc6\u540e\u660e\u6587:" + value);
        System.out.println("--------------\u7b7e\u540d\u8bbe\u7f6ex-sign----------------");
        String IDA = "greatmap";
        String M = "x-area-code610581x-formatjsonx-industry-codeMZx-methodshanxi.api.taxx-sender-idHCSBDCDJXT2021727x-timestamp2021-07-2915:35:30x-version1.0";
        String signature = SM2Utils.sign(M, IDA, publicKey, privateKey);
        System.out.println("\u7528\u6237\u6807\u8bc6:" + IDA);
        System.out.println("\u7b7e\u540d\u4fe1\u606f:" + M);
        System.out.println("\u6570\u5b57\u7b7e\u540d:" + signature);
        System.out.println("\u9a8c\u8bc1\u7b7e\u540d:" + SM2Utils.verify(M, signature, IDA, publicKey));
    }

    static {
        random = new SecureRandom();
        curve = new ECCurve.Fp(p, a, b);
        G = curve.createPoint(gx, gy);
        ecc_bc_spec = new ECDomainParameters((ECCurve)curve, G, n);
    }
}

