/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.config;

import com.gtis.config.AppConfig;
import com.gtis.config.AppDsUtil;
import com.gtis.config.EncryptHelper;
import com.gtis.config.PropertyPlaceholderHelper;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class AppConfigPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private static final PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper("${", "}", ":", true);

    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) throws BeansException {
        AppConfig.setConfiguration(props);
        super.processProperties(beanFactoryToProcess, props);
    }

    protected Properties mergeProperties() throws IOException {
        Properties props = super.mergeProperties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String v = (String)entry.getValue();
            if (v != null && v.startsWith("!!")) {
                entry.setValue(EncryptHelper.decrypt(v));
                continue;
            }
            if (v == null || !v.startsWith("snepamtg")) continue;
            entry.setValue(AppDsUtil.dcpWithPrefix(v, "snepamtg"));
        }
        return props;
    }

    protected String parseStringValue(String strVal, final Properties props, Set visitedPlaceholders) throws BeanDefinitionStoreException {
        return helper.replacePlaceholders(strVal, new PropertyPlaceholderHelper.PlaceholderResolver(){

            @Override
            public String resolvePlaceholder(String placeholderName) {
                return AppConfigPlaceholderConfigurer.this.resolvePlaceholder(placeholderName, props, 1);
            }
        });
    }
}

