/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.common.util;

import com.gtis.common.util.ObjectInputStreamWithClassLoader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ByteObjectAccess {
    protected static final Log log = LogFactory.getLog(ByteObjectAccess.class);

    public static String objectToString(Object obj) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream gzipout = new GZIPOutputStream(bos);
        ObjectOutputStream ois = new ObjectOutputStream(gzipout);
        ois.writeObject(obj);
        ois.flush();
        gzipout.finish();
        byte[] b = bos.toByteArray();
        ois.close();
        gzipout.close();
        bos.close();
        return ByteObjectAccess.encode(b);
    }

    public static Object stringToObject(String value) throws Exception {
        byte[] b = ByteObjectAccess.decode(value);
        ByteArrayInputStream bis = new ByteArrayInputStream(b);
        GZIPInputStream gzipin = new GZIPInputStream(bis);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        ObjectInputStreamWithClassLoader ois = new ObjectInputStreamWithClassLoader(gzipin, cl);
        Object obj = ois.readObject();
        ois.close();
        gzipin.close();
        bis.close();
        return obj;
    }

    public static String encode(byte[] bArray) {
        StringBuffer hs = new StringBuffer();
        String stmp = null;
        for (int n = 0; n < bArray.length; ++n) {
            stmp = Integer.toHexString(bArray[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append("0").append(stmp);
                continue;
            }
            hs.append(stmp);
        }
        return hs.toString().toUpperCase();
    }

    public static byte[] decode(String value) {
        if (value == null) {
            return null;
        }
        int length = value.length();
        char[] charArray = value.toCharArray();
        int n = length / 2;
        byte[] b = new byte[n];
        for (int i = 0; i < n; ++i) {
            b[i] = ByteObjectAccess.toByte(charArray[2 * i], charArray[2 * i + 1]);
        }
        return b;
    }

    private static byte toByte(char ch1, char ch2) {
        int x = 0;
        if (ch1 >= '0' && ch1 <= '9') {
            x = ch1 - 48;
        } else if (ch1 >= 'A' && ch1 <= 'F') {
            x = ch1 - 65 + 10;
        }
        int y = 0;
        if (ch2 >= '0' && ch2 <= '9') {
            y = ch2 - 48;
        } else if (ch2 >= 'A' && ch2 <= 'F') {
            y = ch2 - 65 + 10;
        }
        return (byte)(x * 16 + y);
    }

    public static void main(String[] args) {
    }
}

