package com.gtis.sql.dialect;

/**
 * SQL方言接口
 *
 * @author C4ISR
 */
public interface Dialect {

    /**
     * 是否支持分页查询
     *
     * @return
     */
    public boolean supportsLimit();

    /**
     * 获取分页脚本
     *
     * @param sql
     * @param hasOffset
     * @return
     */
    public String getLimitString(String sql, boolean hasOffset);

    /**
     * 获取分页脚本
     *
     * @param sql
     * @param offset
     * @param limit
     * @return
     */
    public String getLimitString(String sql, int offset, int limit);

    /**
     * 带排序的分页脚本
     *
     * @param sql
     * @param offset
     * @param limit
     * @param orderField
     * @param orderType
     * @return
     */
    public String getLimitString(String sql, int offset, int limit, String orderField, boolean desc);
}
