package com.gtis.plat.wf.model;

import org.dom4j.Node;

import java.io.Serializable;

/**
 * User: JIFF
 * Date: 2014/10/29
 */
public class SubProcessModel implements Serializable {

    private static final long serialVersionUID = 4692228766961659100L;
    String id;
    String name;
    boolean lockParentProject;

    public boolean isLockParentProject() {
        return lockParentProject;
    }

    public void setLockParentProject(boolean lockParentProject) {
        this.lockParentProject = lockParentProject;
    }

    public SubProcessModel(Node aNode) {
        this.id=aNode.valueOf("@Id");
        this.name=aNode.valueOf("@Name");
        lockParentProject=Boolean.parseBoolean(getExtendedAttribute(aNode,"LockParentProject"));
    }

    public String getExtendedAttribute(Node aNode,String aName) {
        Node tmpNode = aNode
                .selectSingleNode("ExtendedAttributes/ExtendedAttribute[@Name='"
                        + aName + "']");
        if (tmpNode != null) {
            return tmpNode.valueOf("@Value");
        } else {
            return "";
        }
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
