package com.gtis.plat.wf;

import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WorkFlowInfo implements Serializable {

    private static final long serialVersionUID = 4258293036516105789L;
    WorkFlowResult result;  //结果
    String userId;  //当前用户
    PfWorkFlowDefineVo workFlowDefineVo;  //工作流定义
    PfWorkFlowInstanceVo workFlowIntanceVo; //工作流实例

    PfActivityVo sourceActivity;         //源活动
    PfTaskVo sourceTask;                  //源任务
    WorkFlowTransInfo transInfo;   //转发列表

    List<PfActivityVo> targetActivitys;  //目标活动
    List<PfTaskVo> targetTasks;          //目标任务

    Map<String,List<Map>> subProcessEndTargetActivities;

    HashMap<String,String> selectAcMap;  //针对退回所增加的一个属性，存储退回的节点和参与人员

    public PfWorkFlowInstanceVo getWorkFlowIntanceVo() {
        return workFlowIntanceVo;
    }

    public void setWorkFlowIntanceVo(PfWorkFlowInstanceVo workFlowIntanceVo) {
        this.workFlowIntanceVo = workFlowIntanceVo;
    }

    public WorkFlowResult getResult() {
        return result;
    }

    public void setResult(WorkFlowResult result) {
        this.result = result;
    }

    public PfWorkFlowDefineVo getWorkFlowDefineVo() {
        return workFlowDefineVo;
    }

    public void setWorkFlowDefineVo(PfWorkFlowDefineVo workFlowDefineVo) {
        this.workFlowDefineVo = workFlowDefineVo;
    }

    public PfActivityVo getSourceActivity() {
        return sourceActivity;
    }

    public void setSourceActivity(PfActivityVo sourceActivity) {
        this.sourceActivity = sourceActivity;
    }

    public PfTaskVo getSourceTask() {
        return sourceTask;
    }

    public void setSourceTask(PfTaskVo sourceTask) {
        this.sourceTask = sourceTask;
    }

    public List<PfActivityVo> getTargetActivitys() {
        return targetActivitys;
    }

    public void setTargetActivitys(List<PfActivityVo> targetActivitys) {
        this.targetActivitys = targetActivitys;
    }

    public List<PfTaskVo> getTargetTasks() {
        return targetTasks;
    }

    public void setTargetTasks(List<PfTaskVo> targetTasks) {
        this.targetTasks = targetTasks;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public WorkFlowTransInfo getTransInfo() {
        return transInfo;
    }

    public void setTransInfo(WorkFlowTransInfo transInfo) {
        this.transInfo = transInfo;
    }

    public Map<String, List<Map>> getSubProcessEndTargetActivities() {
        return subProcessEndTargetActivities;
    }

    public void setSubProcessEndTargetActivities(Map<String, List<Map>> subProcessEndTargetActivities) {
        this.subProcessEndTargetActivities = subProcessEndTargetActivities;
    }

    public HashMap<String, String> getSelectAcMap() {
        return selectAcMap;
    }

    public void setSelectAcMap(HashMap<String, String> selectAcMap) {
        this.selectAcMap = selectAcMap;
    }
}
