package com.gtis.plat.service;

import com.gtis.plat.vo.PfUserVo;
import com.gtis.plat.vo.PfWorkFlowDefineVo;
import com.gtis.plat.vo.PfWorkFlowInstanceVo;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface SysWorkFlowInstanceService {

    /**
     * 工作流实例模型
     * 缓存
     *
     * @param workflowIntanceId
     * @return
     */
    public abstract String getWorkflowInstanceXml(String workflowIntanceId);

    /**
     * 工作流实例模型
     * 缓存
     * @param intanceVo
     * @return
     */
    public abstract String getWorkflowInstanceXml(PfWorkFlowInstanceVo intanceVo);

    public abstract void createWorkFlowIntance(PfWorkFlowInstanceVo intanceVo);

    public abstract PfWorkFlowInstanceVo getWorkflowInstance(
            String workflowIntanceId);

    public abstract void updateWorkFlowIntanceStadus(
            PfWorkFlowInstanceVo intanceVo);

    public abstract void deleteWorkFlowIntance(String workflowIntanceId);

    public abstract void updateWorkFlowIntanceName(PfWorkFlowInstanceVo intanceVo);

    /**
     * 更新实例的超期时间
     * @param wiid
     * @param overTime
     */
    public abstract void updateWorkFlowIntanceOverTime(String wiid,Date overTime);

    public abstract void updateWorkFlowInstanceRemark(PfWorkFlowInstanceVo intanceVo);

    public abstract PfWorkFlowInstanceVo getWorkflowInstanceByProId(String proId);

    public abstract String getTaskCount(HashMap<String, String> map);

    public abstract String getTaskOverCount(HashMap<String, String> map);

    public abstract String getProjectCount(HashMap<String, String> map);

    /**
     * 更新工作流全局变量
     *
     * @param workflowIntanceId
     * @param valName
     * @param val
     */
    public abstract void updateGobalVal(String workflowIntanceId, String valName, Object val);

    /**
     * 获得工作流全局变量
     *
     * @param workflowIntanceId
     * @return
     */
    public abstract HashMap<String, Object> getGobalVal(String workflowIntanceId);

    /**
     * 根据实例id获取工作流详细信息的xml描述
     *
     * @param workflowIntanceId workflowIntanceId
     * @return 工作流实例描述xml字符串
     */
    public String getWorkFlowInstanceDetailXml(String workflowIntanceId);

    /**
     * 统计全部待办任务信息，返回map对象，key是用户ID,value是超期任务数目。
     *
     * @param paraMap 可以写入查询的起始日期和结束日期,如果不写，则查全部
     * @return
     */
    public Map<String, Integer> statTaskCountMap(HashMap<String, String> paraMap);

    /**
     * 统计指定工作流活动的任务
     *
     * @param wiid
     * @return
     */
    public int statTaskCountByWiid(String wiid);

    /**
     * 一个工作流最后业务办理的人，对于已经办结的项目，就是办结的人
     *
     * @param wiid
     * @return
     */
    public PfUserVo getWorkFlowLastUser(String wiid);

    /**
     * 根据定义和工作流状态获取工作流实例
     *
     * @param wdId
     * @param state
     * @return
     */
    public List<PfWorkFlowInstanceVo> getWorkFlowsInstanceByDefine(String wdId, int state);

    /**
     * 更新一个实例的督办信息
     * @param wiid
     * @param monitorId
     */
    public void UpdateWorkFlowInstanceMonitor(String wiid,String monitorId);

    /**
     * 更新工作流紧急程度
     * @param wiid
     * @param priority
     */
    public void updateWorkFlowIntancePriority(String wiid,String priority);

    /**
     * 工作流统计
     * @param map
     * @return
     */
    public List<HashMap> getWorkflowStatusList(HashMap<String,String> map);

    /**
     * 获取工作流实例的流程图
     * 因为平台实例表没有提供流程图的属性，因此为了尽量少改动的原则，采用定义表的实体类作为映射对象
     * @param wiid
     * @return
     */
    public PfWorkFlowDefineVo getWorkFlowImage(String wiid);
}