package com.gtis.plat.service;

import com.gtis.plat.vo.PfSubsystemMenuRelVo;
import com.gtis.plat.vo.PfSubsystemVo;

import java.util.List;
import java.util.Map;

/**
 * 子系统服务
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/4/23
 */
public interface SysSubsystemService {
    /**
     * 新增子系统
     * @param pfSubsystemVo 子系统对象
     */
    public void insertSubsystem(PfSubsystemVo pfSubsystemVo);

    /**
     * 删除子系统
     * @param subsystemIds 子系统Ids
     */
    public void deleteSubsystem(List<String> subsystemIds);

    /**
     * 更新子系统
     * @param pfSubsystemVo 子系统对象
     */
    public void updateSubsystem(PfSubsystemVo pfSubsystemVo);

    /**
     * 新增子系统与菜单关系
     * @param pfSubsystemMenuRelVo
     */
    public void insertSubsystemMenuRel(PfSubsystemMenuRelVo pfSubsystemMenuRelVo);

    /**
     * 删除子系统与菜单关系
     * @param subsystemRelIds
     */
    public void deleteSubsystemMenuRel(List<Map> subsystemRelIds);
}
