package com.gtis.plat.service;

import java.util.List;

/**
 * 必填项服务，可以获取到平台的必填项配置
 * @author <a href="mailto:shenjian@gtmap.cn">shenjian</a>
 * @version 1.0, 2015/9/25
 */
public interface SysRequiredFieldsService {

    /**
     * 获取到工作流资源（动态表单，帆软报表，jsp页面）的必填项
     * @param workflowDefinitionId 工作流定义Id
     * @param activityDefinitionId 活动定义Id
     * @param resourceName 资源名称
     * @param proid 项目id
     * @return
     */
    public List<String> getResourceRequiredFieldsByResourceName(String workflowDefinitionId,String activityDefinitionId,
                                                          String resourceName,String proid);

    /**
     * 获取到工作流资源（动态表单，帆软报表，jsp页面）的必填项
     * @param workflowDefinitionId 工作流定义Id
     * @param activityDefinitionId 活动定义Id
     * @param resourceId 资源Id
     * @param proid 项目id
     * @return
     */
    public List<String> getResourceRequiredFieldsByResourceId(String workflowDefinitionId,String activityDefinitionId,
                                                                      String resourceId,String proid);


}
