package com.gtis.plat.service;

import com.gtis.plat.vo.PfMenuVo;
import com.gtis.plat.vo.PfResourceVo;
import com.gtis.plat.vo.UserInfo;

import java.util.List;


public interface SysMenuService {

    /**
     * 获取用户菜单
     * @param userInfo
     * @return
     */
    public abstract List<PfMenuVo> getMenusByUserInfo(UserInfo userInfo);

    /**
     * 根据资源编号获取资源
     *
     * @param rid
     * @return
     */
    public abstract PfResourceVo getResource(String rid);

    /**
     * 根据资源编码获取资源
     *
     * @param code
     * @return
     */
    public abstract PfResourceVo getResourceByCode(String code);

    /**
     * 项目菜单列表
     *
     * @param roles
     * @param wdid
     * @return
     */
    public abstract List<PfResourceVo> getProjectMenu(String roles, String wdid);

    /**
     * 根据用户角色，获取该用户对那些项目有查看权限，项目列表只列出有权限的项目
     *
     * @param roles
     * @return
     */
    public List<String> getProjectWorkFlowDefineIds(String roles);

    /**
     * 根据角色获取系统菜单
     *
     * @param userInfo
     * @return
     */
    public List<PfMenuVo> getSysMenuByUserInfo(UserInfo userInfo);

    /**
     * 获取根节点
     *
     * @param userInfo
     * @param Leaves   是否需要叶节点
     * @return
     */
    public List<PfMenuVo> getRootMenuListByUserInfo(UserInfo userInfo, boolean Leaves);

    /**
     * 根据角色获取二级菜单
     *
     * @param userInfo
     * @return
     */
    public List<PfMenuVo> getRootMenuChildsByRoles(UserInfo userInfo, String menuParentId);

    List<String> getWorkFlowDefineRoleIds(String workflowDefinitionId);


    /**
     * 根据系统代码和角色id查询菜单
     *
     * @param userInfo
     * @return
     */
    public List<PfMenuVo> getRootMenuListByRoles(UserInfo userInfo,String businessCode) ;
}