/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: CacheUtils.java
 *
 * LastModified: 2009-09-22 02:10:10
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.generic.cache;

import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringUtils;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-9-21
 */
public class CacheUtils {

    public static final String SEPARATOR = "^";

    public static String getKey(Object... keys) {
        return StringUtils.join(keys, SEPARATOR);
    }

    public static long getExpirationTime(Ehcache cache, Object key) {
        Element element = cache.get(key);
        if (element != null) {
            return element.getExpirationTime();
        }
        return 0;
    }

    public static <T> T load(Ehcache cache, Object key) {
        return load(cache, key, null, null);
    }

    public static <T> T load(Ehcache cache, Object key, EntityLoader loader) {
        return load(cache, key, loader, null);
    }

    @SuppressWarnings("unchecked")
    public static <T> T load(Ehcache cache, Object key, EntityLoader loader, Integer expire) {
        Element element = null;
        cache.acquireReadLockOnKey(key);
        try {
            element = cache.get(key);
        }finally {
            cache.releaseReadLockOnKey(key);
        }
        if (element != null) {
            return (T) element.getObjectValue();
        } else {
            if (loader == null)
                return null;
            Object value = loader.loadOnMiss();
            if (value == null)
                return null;
            put(cache, key, value, expire);
            return (T) value;
        }
    }

    public static void put(Ehcache cache, Object key, Object value) {
        put(cache, key, value, null);
    }

    public static void put(Ehcache cache, Object key, Object value, Integer expire) {
        cache.acquireWriteLockOnKey(key);
        try {
            cache.put(expire == null ? new Element(key, value) : new Element(key, value, null, expire, expire));
        }finally {
            cache.releaseWriteLockOnKey(key);
        }

    }
}
