/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: StoreUrl.java
 *
 * LastModified: 2009-09-16 01:40:53
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.fileCenter.model.impl;

import com.gtis.fileCenter.ex.NestedRuntimeException;

import java.io.File;
import java.io.Serializable;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-9-16
 */
public class StoreUrl implements Serializable {

    private static final long serialVersionUID = 4365856897181933691L;

    public static final String STORE_PROTOCOL = "store://";

    private String storeName;

    private String path;

    private File file;

    public StoreUrl(String str) {
        int index;
        if (str.startsWith(StoreUrl.STORE_PROTOCOL))
            index = 8;
        else
            throw new NestedRuntimeException("url is invalid : " + str);
        String path = str.substring(index);
        index = path.indexOf('/');
        if (index == -1)
            throw new NestedRuntimeException("url is invalid : " + str);
        storeName = path.substring(0, index);
        this.path = path.substring(index + 1, path.length());
    }

    public StoreUrl(String storeName, String path) {
        this.storeName = storeName;
        this.path = path;
    }

    public String getStoreName() {
        return storeName;
    }

    public String getPath() {
        return path;
    }

    public File getFile() {
        return file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(StoreUrl.STORE_PROTOCOL).append(storeName).append(path);
        return sb.toString();
    }

}
