package com.gtis.dform.xml;

import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

import java.io.InputStream;

/**
 * Created by IntelliJ IDEA.
 * User: Administrator
 * Date: 11-9-5
 * Time: 下午1:34
 * To change this template use File | Settings | File Templates.
 */
public class FormXmlFactoryBean implements FactoryBean, InitializingBean {
    private Resource[] configLocations;
    FormXmlModelCollection modelCollection;

    public void setConfigLocation(Resource configLocation) {
        this.configLocations = (configLocation != null ? new Resource[]{configLocation} : null);
    }

    public Resource[] getConfigLocations() {
        return configLocations;
    }

    public void setConfigLocations(Resource[] configLocations) {
        this.configLocations = configLocations;
    }


    public FormXmlModelCollection getModelCollection() {
        return modelCollection;
    }

    public void setModelCollection(FormXmlModelCollection modelCollection) {
        this.modelCollection = modelCollection;
    }

    public Object getObject() throws Exception {
        return this.modelCollection;
    }

    public Class getObjectType() {
        return (this.modelCollection != null ? this.modelCollection.getClass() : FormXmlModelCollection.class);
    }

    public boolean isSingleton() {
        return true;  //To change body of implemented methods use File | Settings | File Templates.
    }

    public void afterPropertiesSet() throws Exception {
        //解析xml
        modelCollection = new FormXmlModelCollection();
        //得到SAXReader对象
        SAXReader saxReadr = new SAXReader();
        for (int i = 0; i < configLocations.length; i++) {
            InputStream is = configLocations[i].getInputStream();
            try {
                Document doc = saxReadr.read(is);
                modelCollection.parser(doc.getRootElement());
            } catch (Exception ex) {
                throw new Exception("Failed to parse config resource: " + configLocations[i], ex.getCause());
            }
        }
    }
}
