/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.fileCenter.service.impl;

import com.gtis.fileCenter.ex.NestedRuntimeException;
import com.gtis.fileCenter.service.MimeTypeService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MimeTypeServiceImpl
implements MimeTypeService {
    public static final String DEFAULT_CONFIG = "mimetype-map.xml";
    private Map<String, String> extensionsByMimetype;
    private Map<String, String> mimeTypesByExtension;
    private Map<String, String> iconsByExtension;

    public MimeTypeServiceImpl() {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.getClass().getResourceAsStream(DEFAULT_CONFIG));
            List list = DomUtils.getChildElementsByTagName((Element)doc.getDocumentElement(), (String)"mime-mapping");
            this.extensionsByMimetype = new HashMap<String, String>(list.size());
            this.mimeTypesByExtension = new HashMap<String, String>(list.size());
            this.iconsByExtension = new HashMap<String, String>(list.size());
            for (Object o : list) {
                Element ele = (Element)o;
                String extension = DomUtils.getChildElementValueByTagName((Element)ele, (String)"extension");
                String mimeType = DomUtils.getChildElementValueByTagName((Element)ele, (String)"mime-type");
                String icon = DomUtils.getChildElementValueByTagName((Element)ele, (String)"icon");
                this.extensionsByMimetype.put(mimeType, extension);
                this.mimeTypesByExtension.put(extension, mimeType);
                if (icon == null) continue;
                this.iconsByExtension.put(extension, icon);
            }
        }
        catch (Exception e) {
            throw new NestedRuntimeException("parse mimeType file: mimetype-map.xml error", e);
        }
    }

    public String getExtension(String mimeType) {
        return this.extensionsByMimetype.get(mimeType);
    }

    public String getIcon(String fileName) {
        String ext = this.getExt(fileName);
        if (ext != null && this.iconsByExtension.containsKey(ext)) {
            return this.iconsByExtension.get(ext);
        }
        return "unknow.gif";
    }

    public String getMimeType(String fileName) {
        String ext = this.getExt(fileName);
        if (ext != null && this.mimeTypesByExtension.containsKey(ext)) {
            return this.mimeTypesByExtension.get(ext);
        }
        return "application/octet-stream";
    }

    private String getExt(String fileName) {
        int index;
        if (fileName != null && (index = fileName.lastIndexOf(46)) > -1 && index < fileName.length() - 1) {
            return fileName.substring(index + 1).toLowerCase();
        }
        return null;
    }
}

