/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.fileCenter;

import com.gtis.fileCenter.CustomFilePart;
import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.service.NodeService;
import java.io.File;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ResourceUtils;

public class FileUploadUtil {
    static Log log = LogFactory.getLog(FileUploadUtil.class);

    public static boolean uploadFile(String uploadUrl, NodeService nodeService, int nodeId, String fileFullName) {
        Node fileNode = nodeService.getNodeByType(nodeId);
        if (fileNode != null) {
            String token = nodeService.getToken(fileNode);
            try {
                File newFile = ResourceUtils.getFile((String)fileFullName);
                if (newFile.exists()) {
                    PostMethod filePost = new PostMethod(uploadUrl);
                    Part[] parts = new Part[]{new StringPart("nid", "" + fileNode.getId()), new StringPart("token", token), new StringPart("cover", "true"), new CustomFilePart(newFile.getName(), newFile)};
                    filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
                    HttpClient client = new HttpClient();
                    int status = client.executeMethod((HttpMethod)filePost);
                    if (200 == status) {
                        return true;
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"----\u6587\u4ef6\u4e2d\u5fc3\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff01----", e.getCause());
            }
        }
        return false;
    }
}

