package com.gtis.search;

import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.*;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-1-10
 */
public class DefaultCategoryFactory extends AbstractIndexTemplateSupport implements CategoryFactory {
    protected Category category;
    protected Set<String> unSearchableFields = new HashSet<String>();
    protected List<DataFetcher> dataFetchers;

    public DefaultCategoryFactory() {
        category = new Category();
    }

    public void setId(String id) {
        category.setId(id);
    }

    public void setName(String name) {
        category.setName(name);
    }

    public void setIcon(String icon) {
        category.setIcon(icon);
    }

    @Override
    public void setTplVars(Map<String, Serializable> vars) {
        category.setTplVars(vars);
    }

    @Override
    public void setTplText(String name, String text) {
        category.addTpl(name, StringUtils.replace(text, "%{", "${"));
    }

    public void setUnSearchableFieldArray(String[] unSearchableFields) {
        Collections.addAll(this.unSearchableFields, unSearchableFields);
    }

    public void setDataFetchers(List<DataFetcher> dataFetchers) {
        this.dataFetchers = dataFetchers;
    }

    public String getId() {
        return category.getId();
    }

    public Category getCategory(Business business) {
        prepareCategory(business, category);
        return category;
    }

    protected void prepareCategory(Business business, Category category) {
        if (category.getBusinessId() == null) {
            category.setBusinessId(business.getId());
        }
        if (dataFetchers != null) {
            for (DataFetcher dataFetcher : dataFetchers) {
                prepareDataFetcher(business, category, dataFetcher);
            }
        }
        reloadTpl();
    }

    protected void prepareDataFetcher(Business business, Category category, DataFetcher dataFetcher) {
    }

    public List<DataFetcher> getDataFetchers() {
        return dataFetchers;
    }

    public Set<String> getUnSearchableFields() {
        return unSearchableFields;
    }
}
