package com.gtis.search;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-1-10
 */
public final class Business extends AbstractCategory implements Serializable, Cloneable {
    private static final long serialVersionUID = 3253735220074827532L;
    private List<Category> categories = new ArrayList<Category>();
    private Long lastModified;

    public List<Category> getCategories() {
        return categories;
    }

    public void setCategories(List<Category> categories) {
        this.categories = categories;
    }

    public Long getLastModified() {
        return lastModified;
    }

    public void setLastModified(Long lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Business && getId().equals(((Business) obj).getId());
    }

    @Override
    public int hashCode() {
        return getId().hashCode();
    }

    @Override
    public Business clone() {
        try {
            Business biz = (Business) super.clone();
            biz.setTpls(new HashMap<String, String>(getTpls()));
            biz.setTplVars(new HashMap<String, Serializable>(getTplVars()));
            return biz;
        } catch (CloneNotSupportedException e) {
            return null;
        }
    }
}
