package com.gtis.plat.service;

import com.gtis.plat.vo.EcSupervisorVo;

import java.util.HashMap;
import java.util.List;

public interface SysSupervisorService {

    //保存督办信息
    public EcSupervisorVo saveEcSupervisorVo(EcSupervisorVo supervisor);

    //根据 ExceptionID 获取 督办信息
    public EcSupervisorVo queryEcSupervisorVoByExceptionId(String exceptionID);

    //更新督办信息
    public void updateEcSupervisorVo(HashMap map);

    /**
     * 根据 userId 和 workflowInstanceId 获得 督办列表
     *
     * @param condition
     * @return
     */
    public List<HashMap> getSupervisorDetailList(HashMap condition);

    //根据督办ID 获得督办
    public HashMap queryEcSupervisorById(HashMap condition);

    /**
     * 回复督办信息
     *
     * @param condition
     * @return
     */
    public int fillEcSuperExplain(EcSupervisorVo supervisorVo);

    //领导发出督办信息 保存
    public void saveEcSupervisorVoByLeader(HashMap map);

    //根据项目ID统计所有督办
    public List<HashMap> statSupervisorByInstanceId(String instanceId);

    /**
     * 更新督办解释
     *
     * @param supervisorService
     * @return
     */
    public boolean updateSuperviseExplain(EcSupervisorVo supervisor);

    /**
     * 获取异常信息
     *
     * @param workflowInstanceId
     * @return
     */
    public List<HashMap> getExceptionInfo(String workflowInstanceId);

    /**
     * 获取未回复的督办
     *
     * @param activityId
     * @return
     */
    public List<EcSupervisorVo> getUnansweredSupervisorVoListByActivityId(String activityId);
}
