package com.gtis.plat.service;

import com.gtis.plat.vo.PfOpinionVo;

import java.util.HashMap;
import java.util.List;

public interface SysOpinionService {

    /**
     * 根据UserID获得默认意见列表
     * 这个方法包括默认意见，默认意见为userid为0的管理员的意见
     *
     * @param UserId
     */
    public List<PfOpinionVo> getOpinionListByUserId(String UserId);

    /**
     * 根据UserID获得默认意见列表
     *
     * @param UserId
     * @return
     */
    public List<PfOpinionVo> getOpinionList(String UserId);

    /**
     * 新增默认意见
     *
     * @param vo
     */
    public void insertOpinion(PfOpinionVo vo);

    /**
     * 更新默认意见
     */
    public void updateOpinion(PfOpinionVo vo);

    /**
     * 删除默认意见
     */
    public void deleteOpinion(String opinId);

    /**
     * 根据OPIN_ID查询意见
     *
     * @param OpinId
     */
    public PfOpinionVo getOpinionByOpinId(String OpinId);

    /**
     * 根据OPIN_ID更新意见是否
     *
     * @param map
     */
    public void updateIsUseByOpinId(HashMap<String, String> map);

    /**
     * 根据用户Id和Type类型,查找意见列表
     *
     * @param userId
     * @param type
     * @return
     */
    public List<PfOpinionVo> getOpinionList(String userId, String type);
}
