package com.gtis.fileCenter;

import com.gtis.fileCenter.model.Node;
import com.gtis.fileCenter.service.NodeService;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ResourceUtils;

import java.io.File;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:jibo1024@gmail.com">boji</a>
 * @version V1.0, ${Date}
 */
public class FileUploadUtil {

    static Log log = LogFactory.getLog(FileUploadUtil.class);

    /**
     * 上传本地文件到文件中心
     *
     * @param uploadUrl    文件中心服务url /file/upload.do
     * @param nodeService  文件中心服务
     * @param nodeId       文件中心节点编号
     * @param fileFullName 文件名称带路径
     * @return HttpStatus 成功为HttpStatus.SC_OK 200
     */
    public static boolean uploadFile(String uploadUrl, NodeService nodeService, int nodeId, String fileFullName) {
        Node fileNode = nodeService.getNodeByType(nodeId);

        if (fileNode != null) {
            String token = nodeService.getToken(fileNode);
            try {
                File newFile = ResourceUtils.getFile(fileFullName);
                if (newFile.exists()) {
                    PostMethod filePost = new PostMethod(uploadUrl);
                    Part[] parts = {
                            new StringPart(Constants.NODE_ID, "" + fileNode.getId()),
                            new StringPart(Constants.TOKEN, token),
                            new StringPart("cover", "true"),
                            new CustomFilePart(newFile.getName(), newFile)
                    };
                    filePost.setRequestEntity(
                            new MultipartRequestEntity(parts, filePost.getParams())
                    );
                    HttpClient client = new HttpClient();
                    int status = client.executeMethod(filePost);
                    if (HttpStatus.SC_OK == status)
                        return true;
                }
            } catch (Exception e) {
                log.error("----文件中心上传文件失败！----", e.getCause());
            }
        }
        return false;
    }


}
