/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.search;

import com.gtis.search.AbstractIndexTemplateSupport;
import com.gtis.search.Business;
import com.gtis.search.BusinessFactory;
import com.gtis.search.Category;
import com.gtis.search.CategoryFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBusinessFactory
extends AbstractIndexTemplateSupport
implements BusinessFactory {
    protected Business business;
    protected Map<String, CategoryFactory> categoryFactories = new HashMap<String, CategoryFactory>();

    public DefaultBusinessFactory() {
        this.business = new Business();
        this.business.setLastModified(System.currentTimeMillis());
    }

    public void setId(String id) {
        this.business.setId(id);
    }

    public void setName(String name) {
        this.business.setName(name);
    }

    public void setIcon(String icon) {
        this.business.setIcon(icon);
    }

    public void setUpdateable(boolean updateable) {
        if (updateable) {
            this.business.setLastModified(null);
        }
    }

    @Override
    public void setTplVars(Map<String, Serializable> vars) {
        this.business.setTplVars(vars);
    }

    @Override
    public void setTplText(String name, String text) {
        this.business.addTpl(name, StringUtils.replace((String)text, (String)"%{", (String)"${"));
    }

    public void setCategoryFactories(List<CategoryFactory> categoryFactories) {
        for (CategoryFactory cf : categoryFactories) {
            this.categoryFactories.put(cf.getId(), cf);
        }
    }

    @Override
    public String getId() {
        return this.business.getId();
    }

    @Override
    public Business getBusiness() {
        List<Category> categories = this.business.getCategories();
        categories.clear();
        if (this.categoryFactories != null) {
            for (CategoryFactory factory : this.categoryFactories.values()) {
                categories.add(factory.getCategory(this.business));
            }
        }
        if (categories.isEmpty()) {
            Category cat = new Category();
            cat.setId(this.business.getId());
            cat.setBusinessId(this.business.getId());
            categories.add(cat);
        }
        this.prepareBusiness(this.business);
        return this.business;
    }

    @Override
    public CategoryFactory getCategoryFactory(String categoryId) {
        return this.categoryFactories.get(categoryId);
    }

    protected void prepareBusiness(Business business) {
        this.reloadTpl();
    }
}

