package com.gtis.plat.wf.model;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Node;

import java.io.Serializable;

/**
 * @(#)RiskModel.java 11-3-30 下午2:27
 * Copy Right Information	: 南京国图
 * Project 					:
 * JDK version used		    : jdk1.5.0_20
 * Comments					:
 * Version					:
 * CreateAuthor             : ShiHui
 */
public class RiskModel implements Serializable {

    private Node riskNode;
    /**
     * 主键
     */
    private String id;
    /**
     * 风险点类别
     */
    private String type;
    /**
     * 风险点描述
     */
    private String descrtption;
    /**
     * 是否风险点
     */
    private Integer isRisk; //字典选项：0:否/1:是

    public RiskModel(Node aNode) {
        this.riskNode = aNode;
        this.id = aNode.valueOf("@Id");
        this.type = aNode.valueOf("@Type");
        this.descrtption = aNode.getText();
        if (StringUtils.isNotBlank(aNode.valueOf("@Value"))) {
            this.isRisk = Integer.parseInt(aNode.valueOf("@Value"));
        }
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDescrtption() {
        return descrtption;
    }

    public void setDescrtption(String descrtption) {
        this.descrtption = descrtption;
    }

    public int getRisk() {
        return isRisk;
    }

    public void setRisk(int risk) {
        isRisk = risk;
    }

    public Node getRiskNode() {
        return riskNode;
    }

    public void setRiskNode(Node riskNode) {
        this.riskNode = riskNode;
    }
}
