package com.gtis.plat.service;

import com.gtis.plat.vo.PfActivityVo;
import com.gtis.plat.vo.PfTaskVo;

import java.util.List;

public interface SysTaskService {

    /**
     * 根据主健获取活动
     *
     * @param activityId
     * @return
     */
    public PfActivityVo getActivity(String activityId);

    /**
     * 根据流程实例和活动定义获取活动
     *
     * @param workflowInstanceId
     * @param activityDefinitionId
     * @return
     */
    public PfActivityVo getActivityBywIdandadId(String workflowInstanceId,
                                                String activityDefinitionId);

    /**
     * 获取实例中处于活动状态的活动
     *
     * @param workflowInstanceId
     * @return
     */
    public List<PfActivityVo> getWorkFlowInstanceActivityList(
            String workflowInstanceId);

    /**
     * 根据activityId，获取由此id创建的活动
     *
     * @param activityId
     * @return
     */
    public List<PfActivityVo> getActivityByBefore(
            String activityId);

    /**
     * 根据任务主键获取任务(仅在没有办结的任务中查找)
     *
     * @param taskId
     * @return
     */
    public PfTaskVo getTask(String taskId);

    /**
     * 根据任务主键获取任务（在所有任务中查找）
     *
     * @param taskId
     * @return
     */
    public PfTaskVo getTaskAll(String taskId);

    /**
     * 根据活动获取任务
     *
     * @param activityId
     * @return
     */
    public List<PfTaskVo> getTaskListByActivity(String activityId);

    /**
     * 获取活动下的历史任务
     *
     * @param activityId
     * @return
     */
    public List<PfTaskVo> getHistoryTasks(String activityId);

    /**
     * 设置活动的退回状态
     *
     * @param activityId
     */
    public void updateActivityBackStadus(String activityId, boolean isBack);

    /**
     * 根据活动备注
     *
     * @param activityId
     * @param remark
     */
    public void updateActivityRemark(String activityId, String remark);

    /**
     * 更新活动状态
     *
     * @param activityId
     * @param stadus
     */
    public void updateActivityStadus(String activityId, int stadus);


    /**
     * 更新协办标识+
     *
     * @param activityId
     */
    public void updateCooperateStateUp(String activityId);

    /**
     * 更新协办标识-
     *
     * @param activityId
     */
    public void updateCooperateStateDown(String activityId);

    /**
     * 删除一个活动下的任务
     *
     * @param activityId
     */
    public void deleteActivityTask(String activityId);

    /**
     * 删除指定任务
     *
     * @param taskId
     */
    public void deleteTask(String taskId);

    /**
     * 删除一个工作流实例下的活动
     */
    public void deleteWorkFlowInstanceActivity(String workflowIntanceId);

    /**
     * 复制任务到任务历史表
     *
     * @param taskId
     */
    public void insertTaskHistory(String taskId);

    /**
     * 创建活动
     *
     * @param activityVo
     */
    public void createActivity(PfActivityVo activityVo);

    /**
     * 创建任务
     *
     * @param taskVo
     */
    public void createTask(PfTaskVo taskVo);

    /**
     * 删除历史任务
     *
     * @param activityId
     */
    public void deleteHistoryTaskByActivityId(String activityId);

    public void createTasks(final List<PfTaskVo> tasklist);

    public List<PfTaskVo> getHistoryTaskListByInstance(String workFlowInstanceId);

    public List<PfTaskVo> getHistoryTaskListByDefineId(String workFlowInstanceId, String activityDefineId);

    public List<PfTaskVo> getTaskListByInstance(String workFlowInstanceId);

    public List<PfActivityVo> getWorkFlowInstanceAllActivityList(
            String workflowInstanceId);

    public PfTaskVo getHistoryTask(String taskId);

    /**
     * 获取一个任务之前的任务列表
     *
     * @param taskVo
     * @return
     */
    public List<PfTaskVo> getHistoryTaskByBefore(PfTaskVo taskVo);

    /**
     * 更新历史任务
     *
     * @param taskVo
     */
    public void updateHistoryTask(PfTaskVo taskVo);

    /**
     * 更新任务备注（意见）
     *
     * @param taskVo
     */
    public void updateTask(PfTaskVo taskVo);

    /**
     * 将临时任务变成正式任务
     *
     * @param activityId
     */
    public void updateTempTask(String activityId);

    /**
     * 根据before获取任务
     *
     * @param taskId
     * @return
     */
    public List<PfTaskVo> getTasksByBefore(String taskId);

    public void createTaskByHistroy(String taskId);

    public void deleteHistoryTask(String taskId);

    public void deleteActivity(String activityId);

    /**
     * 更新任务的正在办理状态
     *
     * @param taskId
     */
    public void updateTaskStadus(String taskId);

    /**
     * 获得该活的任务个数（包括历史）
     *
     * @param activityId
     * @return
     */
    public int getAllTaskCountByActivityId(String activityId);

    /**
     * 获取针对指定的用户，该任务是否办理过（实际是判断是否是退回的任务）
     *
     * @param activityId
     * @return
     */
    public List<PfTaskVo> getHistoryTaskListByActivity(String activityId);

    /**
     * 删除其他人的任务，取件功能
     *
     * @param taskId
     */
    public void deleteOtherTasks(String taskId);
}