/*
 * Author: xyang
 *
 * Project: fileCenter
 *
 * File: NodeNotFoundException.java
 *
 * LastModified: 2009-09-22 11:46:18
 *
 * Copyright (c) 2009 gtis. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 *
 * Issued by gtis Ltd.
 */

package com.gtis.fileCenter.ex;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 2009-9-16
 */
public class NodeNotFoundException extends NestedRuntimeException {

    private static final long serialVersionUID = -6814902682830899610L;
    private Integer nodeId;

    public Integer getNodeId() {
        return nodeId;
    }

    public NodeNotFoundException(Integer nodeId) {
        super("nodeId [" + nodeId + "] not found");
        this.nodeId = nodeId;
    }

    public NodeNotFoundException(Integer parentNodeId, String name) {
        super("nodeName [" + name + "] under nodeId [" + parentNodeId + "] not found");
        this.nodeId = parentNodeId;
    }

    public NodeNotFoundException(String msg) {
        super(msg);
    }

    public NodeNotFoundException(String msg, Throwable cause) {
        super(msg, cause);
    }

}
