/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.spring;

import com.gtis.spring.ChildOf;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

public class ChildOfAnnotationProcessor
implements BeanFactoryPostProcessor,
PriorityOrdered {
    protected static final Log LOG = LogFactory.getLog(ChildOfAnnotationProcessor.class);
    private int order = Integer.MAX_VALUE;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] beanNames;
        for (String beanName : beanNames = beanFactory.getBeanDefinitionNames()) {
            BeanDefinition bd = beanFactory.getBeanDefinition(beanName);
            String className = bd.getBeanClassName();
            if (!StringUtils.hasText((String)className)) continue;
            try {
                String oldParentName;
                Class<?> clazz = Class.forName(className);
                ChildOf childOf = (ChildOf)AnnotationUtils.findAnnotation(clazz, ChildOf.class);
                if (childOf == null) continue;
                String parentName = childOf.parent();
                if (!StringUtils.hasText((String)parentName)) {
                    throw new FatalBeanException("ChildOf Annotation of bean [" + beanName + "] has no parent Value");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Found parentName [" + parentName + "] for bean [" + beanName + "]"));
                }
                if (StringUtils.hasText((String)(oldParentName = bd.getParentName())) && !parentName.equals(oldParentName)) {
                    LOG.warn((Object)("bean [" + beanName + "] has already parent [" + oldParentName + "] set - new annotated parent[" + parentName + "] will be ignored"));
                }
                bd.setParentName(parentName);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)("Bean [" + beanName + "] has invalid ClassName[" + bd.getBeanClassName() + "] - Exception will be ignored"));
            }
        }
    }
}

