package com.gtis.util;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/**
 * <p/> 用来执行异步的线程方法
 *
 * @version V1.0,
 * @author: JIBO
 * @Date: 11-11-16
 */
public class ThreadPool {
    private static final ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);

    public static void execute(Runnable task) {
        executor.execute(task);
    }

    public static Future submit(Runnable task) {
        return executor.submit(task);
    }
}
