package com.gtis.support;

import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jndi.JndiObjectFactoryBean;

import javax.naming.NamingException;
import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.SQLException;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:oxsean@gmail.com">sean yang</a>
 * @version V1.0, 12-6-8
 */
public class JndiSupportBasicDataSource extends BasicDataSource implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(JndiSupportBasicDataSource.class);
    private String jndiName;
    private DataSource jndiDataSource;

    public JndiSupportBasicDataSource() {
        setDriverClassName("oracle.jdbc.driver.OracleDriver");
        setInitialSize(10);//初始连接数目
        setMaxActive(80);//最大连接数目
        setMinIdle(5);//最小连接池空闲连接数量,推荐设置成和初始一致
        setMaxIdle(40);//最大线程池空闲连接数量,推荐为最大值的一半
        setMaxWait(2000);//连接池中连接用完时,新的请求等待时间,毫秒
        setMinEvictableIdleTimeMillis(60000);//一分钟内不使用的空闲连接,则释放
        setTimeBetweenEvictionRunsMillis(30000);//30秒做一次空闲连接检查
        setRemoveAbandoned(true);//启用清理removeAbandonedTimeout秒没有使用的活动连接,清理后并没有放回连接池
        setRemoveAbandonedTimeout(120);//活动连接的最大空闲时间
        setLogAbandoned(true);//连接池收回空闲的活动连接时打印消息
        setDefaultAutoCommit(true);//默认自动提交事务
        setTimeBetweenEvictionRunsMillis(600000);
        setMinEvictableIdleTimeMillis(600000);    // #连接的超时时间，默认为半小时
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return jndiDataSource != null ? jndiDataSource.getConnection() : super.getConnection();
    }

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isNotBlank(jndiName)) {
            JndiObjectFactoryBean factoryBean = new JndiObjectFactoryBean();
            factoryBean.setJndiName(jndiName);
            try {
                factoryBean.afterPropertiesSet();
                jndiDataSource = (DataSource) factoryBean.getObject();
            } catch (NamingException e) {
                LOG.info("JNDI lookup failed,try to use local datasource,ex:[{}]", e.getMessage());
            }
        }
    }
}
