package com.gtis.plat.service;

import com.gtis.plat.vo.PfMessageAcceptAwokeVo;
import com.gtis.plat.vo.PfMessageSendAwokeVo;

import java.util.List;

public interface SysMessageAwokeService {

    /**
     * 通知发送对象
     *
     * @param msgSendAwokeId
     * @return
     */
    public PfMessageSendAwokeVo getSendAwoke(String msgSendAwokeId);

    /**
     * 通知接收对象
     *
     * @param msgAcceptAwokeId
     * @return
     */
    public PfMessageAcceptAwokeVo getAcceptAwoke(String msgAcceptAwokeId);

    /**
     * 修改通知查看状态
     *
     * @param msgAwokeId
     */
    public void updateNotifyStatus(String msgAwokeId);

    /**
     * 添加通知
     *
     * @param vo
     * @return
     */
    public boolean insertNotifyAwoke(PfMessageSendAwokeVo vo);

    /**
     * 删除发送的通知
     *
     * @param awokeSendId
     */
    public void delSendAwokeById(String awokeSendId);

    /**
     * 删除接收到的通知
     *
     * @param awokeAcceptId
     */
    public void delAcceptAwokeById(String awokeAcceptId);

    /**
     * 返回已经被阅读的通知数量
     *
     * @param awokeId
     * @return
     */
    public String getReadedAwokeByAwokeId(String awokeId);

    /**
     * 根据消息的名称获得消息列表 like
     *
     * @param sendMsgTitle
     * @return
     */
    public List<PfMessageSendAwokeVo> getSendMsgAwokeByTitle(String sendMsgTitle);
}
