package com.gtis.dform.excute.impl;

import com.gtis.dform.excute.FormExcuteSplit;
import com.gtis.dform.xml.FormXmlModel;
import com.gtis.dform.xml.FormXmlModelCollection;
import com.gtis.sql.dialect.Dialect;
import com.gtis.web.SplitParam;
import freemarker.template.Configuration;
import freemarker.template.Template;
import org.springframework.jdbc.core.JdbcTemplate;

import java.io.StringWriter;
import java.util.List;

/**
 * Created by IntelliJ IDEA.
 * User: Administrator
 * Date: 11-9-5
 * Time: 下午7:50
 * To change this template use File | Settings | File Templates.
 */
public class FormExecuteSplitBean implements FormExcuteSplit {
    JdbcTemplate jdbcT;
    FormXmlModelCollection formXmlModelCollection;
    Configuration freeMarkerConfigurer;
    Dialect dialectSql;

    public void setJdbcT(JdbcTemplate jdbcT) {
        this.jdbcT = jdbcT;
    }

    public void setDialectSql(Dialect dialectSql) {
        this.dialectSql = dialectSql;
    }

    public void setFormXmlModelCollection(FormXmlModelCollection formXmlModelCollection) {
        this.formXmlModelCollection = formXmlModelCollection;
    }

    public void setFreeMarkerConfigurer(Configuration freeMarkerConfigurer) {
        this.freeMarkerConfigurer = freeMarkerConfigurer;
    }

    public String buildCommond(String id, Object paramMap) {
        StringWriter sw = new StringWriter();
        try {
            Template t = freeMarkerConfigurer.getTemplate(id);
            t.process(paramMap, sw);
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return sw.getBuffer().toString();
    }

    public List queryForList(SplitParam param, int skipSize, int pageSize) {
        String sql;
        FormXmlModel formXmlModel = formXmlModelCollection.getModel(param.getQueryString());
        if (formXmlModel != null) {
            String cmd = buildCommond(formXmlModel.getId(), param.getQueryParam());
            sql = dialectSql.getLimitString(cmd, skipSize, pageSize);
            List result = jdbcT.queryForList(sql);
            return result;
        }
        return null;
    }

    public int getCount(SplitParam param) {
        int count = 0;
        String sql;
        FormXmlModel formXmlModel = formXmlModelCollection.getModel(param.getQueryString());
        if (formXmlModel != null) {
            String cmd = buildCommond(formXmlModel.getId(), param.getQueryParam());
            cmd = "select count(*) from ( " + cmd + " )";
            count = jdbcT.queryForInt(cmd);
        }
        return count;
    }

}
