Ccs.widget.DateField = function(field, config) {
    this.field = Ccs.getDom(field);
    this.ct = null;
    this.format = 'Y-m-d H:i';
    Ccs.apply(this, config);
    this.init();
};

Ccs.widget.DateField.prototype = {
    init:function() {
        var html = '<input type="button" class="f-button select-calender-button" value="选择"/>';
        var btn = Ccs.DomHelper.insertAfter(this.field, html, true);
        btn.click(this.show, this, true);
        this.calId = Ccs.id();
    },
    show:function(e) {
        this.day = !this.field.value ? (this.value ? this.value : new Date()) : Date.parseDate(this.field.value, this.format);
        Ccs.Event.stopEvent(e);
        if (!this.ct) {
            var html = ['<div class="cal-date-field" style="display:none;"><div id="',this.calId,'"></div><div class="cal-date-select"><select name="hour">'],i;
            for (i = 0; i < 24; i++) {
                html.push('<option value=' + i + '>' + String.leftPad(i, 2, '0') + '</option>');
            }
            html.push('</select>&nbsp;点　&nbsp;<select name="minute">');
            for (i = 0; i < 60; i += 5) {
                html.push('<option value=' + i + '>' + String.leftPad(i, 2, '0') + '</option>');
            }
            html.push('</select>&nbsp;分<div style="padding:2px;"><input type="button" class="f-button" value="确定"/></div></div></div>');
            this.ct = Ccs.DomHelper.append(document.body, html, true);
            this.hour = this.ct.query('.cal-date-select select[name=hour]').first();
            this.minute = this.ct.query('.cal-date-select select[name=minute]').first();
            this.btn = this.ct.query('.f-button').first();
            this.btn.click(this.updateValue, this, true);
            this.calendar = new YAHOO.widget.Calendar(this.calId, {});
            this.calendar.render();
        }
        this.ct.show();
        this.calendar.cfg.setProperty('pagedate', this.day.format('n/Y'));
        this.calendar.resetRenderers();
        this.calendar.changePageEvent.fire();
        this.calendar.selectCell(this.calendar.getCellIndex(this.day));
        this.hour.dom.value = this.day.getHours();
        this.minute.dom.value = parseInt(this.day.getMinutes() / 5) * 5;
        var el = Ccs(this.field);
        this.ct.setXY([el.getX(),el.getY() + el.dom.offsetHeight + 2]);
        Ccs().click(this.hide, this, true);
    },
    hide:function(e) {
        var el = Ccs(Ccs.Event.getTarget(e));
        if (!el.findParent('.cal-date-field') || el.test('.cal-date-field .f-button')) {
            this.ct.hide();
            Ccs().unClick(this.hide);
        }
    },
    updateValue:function() {
        this.day = this.calendar.getSelectedDates()[0];
        this.day.setHours(parseInt(this.hour.dom.value), parseInt(this.minute.dom.value));
        this.field.value = this.day.format('Y-m-d H:i');
    }
};