(function() {
    var DOC = document;
    Ccs.Element = function(el, forceNew) {
        var dom = typeof el == "string" ? DOC.getElementById(el) : el;
        if (!dom) return null;
        var id = dom.id;
        if (!forceNew && id && Ccs.Element.cache[id]) { // element object already exists
            return Ccs.Element.cache[id];
        }
        this.dom = dom;
        this.id = id || Ccs.id(dom);
    };

    var CD = Ccs.Dom;
    var El = Ccs.Element;
    var EP = El.prototype = {};
    var CE = Ccs.Event;

    Ccs.applyIf(CD, {
        addMethods:function(o) {
            Ccs.apply(EP, o);
        },
        html:function(el, html) {
            if (html) {
                el.innerHTML = html;
                return html;
            } else
                return el.innerHTML;
        },
        focus : function(el, fn, scope, override) {
            if (Ccs.isFunction(fn)) {
                Ccs.on(el, 'focus', fn, scope, override);
                return;
            }
            try {
                if (!isNaN(fn)) {
                    el.focus.defer(fn, el);
                } else {
                    el.focus();
                }
            } catch(e) {
            }
            return el;
        },
        blur : function(el, fn, scope, override) {
            if (Ccs.isFunction(defer)) {
                Ccs.on(el, 'focus', fn, scope, override);
                return;
            }
            try {
                el.blur();
            } catch(e) {
            }
            return el;
        },
        hover:function(el, fnOn, fnOut, scope, override) {
            Ccs.on(el, 'mouseover', fnOn, scope, override);
            Ccs.on(el, 'mouseout', fnOut, scope, override);
        },
        isStyle:function(el, style, val) {
            return CD.getStyle(el, style) == val;
        },
        isVisible:function(el) {
            return !CD.isStyle(el, 'display', 'none');
        },
        hide:function(el) {
            if (CD.isVisible(el))
                CD.setStyle(el, 'display', 'none');
        },
        show:function(el) {
            if (!CD.isVisible(el))
                CD.setStyle(el, 'display', '');
        },
        toggle:function(el) {
            if (CD.isVisible(el))
                CD.hide(el);
            else
                CD.show(el);
        },
        getValue : function(el, asNumber) {
            var val = el.value;
            return asNumber ? parseInt(val, 10) : val;
        },
        remove : function(el) {
            Ccs.removeNode(el);
            delete El.cache[el.id];
        },
        on : function(el, eventName, fn, scope, override) {
            Ccs.on(el, eventName, fn, scope, override);
        },
        un : function(el, eventName, fn) {
            Ccs.un(el, eventName, fn);
        },
        query:function(el, selector, firstOnly) {
            return Ccs.Selector.query(selector, el, firstOnly);
        },
        test:function(el, selector) {
            return Ccs.Selector.test(el, selector);
        },
        filter:function(els, selector) {
            return Ccs.Selector.filter(els, selector);
        },
        findParent : function(el, simpleSelector, maxDepth, returnEl) {
            var b = document.body ,depth = 0, stopEl;
            maxDepth = maxDepth || 50;
            if (isNaN(maxDepth)) {
                stopEl = Ccs.getDom(maxDepth);
                maxDepth = 10;
            }
            while (el && el.nodeType == 1 && depth < maxDepth && el != b && el != stopEl) {
                if (CD.test(el, simpleSelector)) {
                    return returnEl ? Ccs.get(el) : el;
                }
                depth++;
                el = el.parentNode;
            }
            return null;
        }
    });

    Ccs.each(("blur,focus,load,resize,scroll,unload,click,dblclick," +
              "mousedown,mouseup,mousemove,mouseover,mouseout,mouseenter,mouseleave," +
              "change,select,submit,keydown,keypress,keyup,error").split(","), function(eventName) {
        if (!CD[eventName])
            CD[eventName] = function(el, fn, scope, override) {
                Ccs.on(el, eventName, fn, scope, override);
            };
        var unName = 'un' + Ccs.util.Format.capitalize(eventName);
        if (!CD[unName])
            CD[unName] = function(el, fn) {
                Ccs.un(el, eventName, fn);
            };
    });

    Ccs.each(CD, function(fn, name) {
        if (Ccs.isFunction(fn)) {
            EP[name] = function() {
                var ret = fn.apply(this, [this.dom].concat((Ccs.toArray(arguments))));
                if (Ccs.isArray(ret)) {
                    if (ret[0] && ret[0].tagName)
                        ret = new Ccs.CompositeElement(ret);
                } else {
                    ret = Ccs.get(ret);
                }
                return ret;
            };
        }
    });

    var docEl;
    El.cache = {};

    El.get = function(el) {
        var ex,elm,id;
        if (!el)
            return el;
        if (typeof el == "string") { // element id
            if (!(elm = DOC.getElementById(el))) {
                return null;
            }
            if (ex = El.cache[el]) {
                ex.dom = elm;
            } else {
                ex = El.cache[el] = new El(elm);
            }
            return ex;
        } else if (el.tagName) { // dom element
            if (!(id = el.id)) {
                id = Ccs.id(el);
            }
            if (ex = El.cache[id]) {
                ex.dom = el;
            } else {
                ex = El.cache[id] = new El(el);
            }
            return ex;
        } else if (el instanceof El) {
            if (el != docEl) {
                el.dom = DOC.getElementById(el.id) || el.dom; // refresh dom element in case no longer valid,
                // catch case where it hasn't been appended
                El.cache[el.id] = el; // in case it was created directly with Element(), let's cache it
            }
            return el;
        } else if (el.isComposite) {
            return el;
        } else if (Ccs.isArray(el)) {
            return CD.select(el);
        } else if (el == DOC) {
            if (!docEl) {
                var f = function() {
                };
                f.prototype = El.prototype;
                docEl = new f();
                docEl.dom = DOC;
            }
            return docEl;
        }
        return el;
    };

    var flyFn = function() {
    };
    flyFn.prototype = El.prototype;
    El.Flyweight = function(dom) {
        this.dom = dom;
    };

    El.Flyweight.prototype = new flyFn();
    El.Flyweight.prototype.isFlyweight = true;
    El._flyweights = {};
    El.fly = function(el, named) {
        var ret = null;
        named = named || '_global';

        if (el = Ccs.getDom(el)) {
            (El._flyweights[named] = El._flyweights[named] || new El.Flyweight()).dom = el;
            ret = El._flyweights[named];
        }
        return ret;
    };

    Ccs.CompositeElement = function(els) {
        this.elements = [];
        this.add(els);
        this.el = new Ccs.Element();
    };

    Ccs.CompositeElement.prototype = {
        isComposite: true,
        getCount : function() {
            return this.elements.length;
        },
        add : function(els) {
            if (els) {
                if (Ccs.isArray(els)) {
                    this.elements = this.elements.concat(els);
                } else {
                    var yels = this.elements;
                    Ccs.each(els, function(e) {
                        yels.push(e);
                    });
                }
            }
            return this;
        },
        invoke : function(fn, args) {
            var els = this.elements,
                    el = this.el;
            Ccs.each(els, function(e) {
                el.dom = e;
                Ccs.Element.prototype[fn].apply(el, args);
            });
            return this;
        },
        item : function(index) {
            var me = this;
            if (!me.elements[index]) {
                return null;
            }
            me.el.dom = me.elements[index];
            return me.el;
        },
        addListener : function(eventName, handler, scope, opt) {
            Ccs.each(this.elements, function(e) {
                Ccs.on(e, eventName, handler, scope || e, opt);
            });
            return this;
        },
        each : function(fn, scope) {
            var me = this,
                    el = me.el;
            Ccs.each(me.elements, function(e, i) {
                el.dom = e;
                return fn.call(scope || el, el, me, i);
            });
            return me;
        },
        first : function() {
            return this.item(0);
        },

        last : function() {
            return this.item(this.getCount() - 1);
        },
        contains : function(el) {
            return this.indexOf(el) != -1;
        },
        indexOf : function(el) {
            return this.elements.indexOf(Ccs.getDom(el));
        },
        replaceElement : function(el, replacement, domReplace) {
            var index = !isNaN(el) ? el : this.indexOf(el),
                    d;
            if (index > -1) {
                replacement = Ccs.getDom(replacement);
                if (domReplace) {
                    d = this.elements[index];
                    d.parentNode.insertBefore(replacement, d);
                    Ccs.removeNode(d);
                }
                this.elements.splice(index, 1, replacement);
            }
            return this;
        },
        clear : function() {
            this.elements = [];
        }
    };

    Ccs.CompositeElement.prototype.on = Ccs.CompositeElement.prototype.addListener;

    var CEP = Ccs.CompositeElement.prototype;

    for (var fnName in EP) {
        if (Ccs.isFunction(EP[fnName])) {
            (function(fnName) {
                CEP[fnName] = EP[fnName] || function() {
                    return this.invoke(fnName, arguments);
                };
            }).call(CEP, fnName);
        }
    }
    Ccs.each(CD, function(fn, name) {
        if (Ccs.isFunction(fn)) {
            CEP[name] = function() {
                var retArr = [];
                for (var i = 0; i < this.elements.length; i++) {
                    var ret = fn.apply(this.el, [this.elements[i]].concat((Ccs.toArray(arguments))));
                    if (ret != null)
                        retArr.push(ret.tagName || ret[0] && ret[0].tagName ? Ccs.get(ret) : ret);
                }
                return retArr.length == 1 ? retArr[0] : retArr;
            };
        }
    });

    Ccs.Dom.select = function(selector, root, firstOnly) {
        var els;
        if (typeof selector == "string") {
            els = Ccs.Selector.query(selector, root, firstOnly);
        } else if (selector.length !== undefined) {
            els = selector;
        } else {
            throw "Invalid selector";
        }
        if (els && els.length > 0)
            return new Ccs.CompositeElement(els);
    };

    Ccs.get = El.get;
    Ccs.fly = El.fly;
    Ccs.query = CD.query;
    Ccs.select = CD.select;
    Ccs.ready = CE.onDOMReady.createDelegate(CE);
    Ccs.on = CE.addListener.createDelegate(CE);
    Ccs.un = CE.removeListener.createDelegate(CE);
})();