/**
 * ccs base lib script
 * modify from Ext 3.0
 * http://www.extjs.com/
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 * @version V1.0, 2009-5-21 09:23:09
 */

if (typeof Ccs == "undefined" || !Ccs) {
    var Ccs = function(selector, context) {
        return Ccs.init(selector, context);
    };
}

if (typeof $ == "undefined" || !$)
    var $ = Ccs;

Ccs.apply = function(o, c, defaults) {
    if (defaults) Ccs.apply(o, defaults);
    if (o && c && typeof c == 'object') {
        for (var p in c) {
            o[p] = c[p];
        }
    }
    return o;
};

(function() {
    var idSeed = 0,
            ua = navigator.userAgent.toLowerCase(),
            check = function(r) {
                return r.test(ua);
            },
            isIE = check(/msie/),
            isIE7 = isIE && check(/msie 7/),
            isIE8 = isIE && check(/msie 8/);
    if (isIE && !(isIE7 || isIE8)) {
        try {
            document.execCommand("BackgroundImageCache", false, true);
        } catch(e) {
        }
    }
    Ccs.apply(Ccs, {
        version : '1.0.0',
        isCcs : true,
        init:function(selector, context) {
            selector = selector || document;
            if (selector.nodeType) { //is node
                return Ccs.get(selector);
            } else if (typeof selector === "string") {
                var el = Ccs.get(selector);
                if (el)
                    return el;
                return Ccs.select(selector, context);
            } else if (Ccs.isFunction(selector)) {
                Ccs.ready(selector);
            }
        },
        applyIf : function(o, c) {
            if (o) {
                for (var p in c) {
                    if (Ccs.isEmpty(o[p])) {
                        o[p] = c[p];
                    }
                }
            }
            return o;
        },
        id : function(el, prefix) {
            return (el = Ccs.getDom(el) || {}).id = el.id || (prefix || "ccs-gen") + (++idSeed);
        },
        extend : function() {
            var io = function(o) {
                for (var m in o) {
                    this[m] = o[m];
                }
            };
            var oc = Object.prototype.constructor;
            return function(sb, sp, overrides) {
                if (Ccs.isObject(sp)) {
                    overrides = sp;
                    sp = sb;
                    sb = overrides.constructor != oc ? overrides.constructor : function() {
                        sp.apply(this, arguments);
                    };
                }
                var F = function() {
                },
                        sbp,
                        spp = sp.prototype;

                F.prototype = spp;
                sbp = sb.prototype = new F();
                sbp.constructor = sb;
                sb.superclass = spp;
                if (spp.constructor == oc) {
                    spp.constructor = sp;
                }
                sb.override = function(o) {
                    Ccs.override(sb, o);
                };
                sbp.superclass = sbp.supr = (function() {
                    return spp;
                });
                sbp.override = io;
                Ccs.override(sb, overrides);
                sb.extend = function(o) {
                    Ccs.extend(sb, o);
                };
                return sb;
            };
        }(),
        override : function(origclass, overrides) {
            if (overrides) {
                var p = origclass.prototype;
                Ccs.apply(p, overrides);
                if (Ccs.isIE && overrides.toString != origclass.toString) {
                    p.toString = overrides.toString;
                }
            }
        },
        namespace : function() {
            var o, d;
            Ccs.each(arguments, function(v) {
                d = v.split(".");
                o = window[d[0]] = window[d[0]] || {};
                Ccs.each(d.slice(1), function(v2) {
                    o = o[v2] = o[v2] || {};
                });
            });
            return o;
        },
        getDom : function(el) {
            if (!el || !document) {
                return null;
            }
            return el.dom ? el.dom : (typeof el == 'string' ? document.getElementById(el) : el);
        },
        urlEncode : function(o, pre) {
            var buf = [],key,e = encodeURIComponent;
            for (key in o) {
                Ccs.each(o[key] || key, function(val) {
                    buf.push("&", e(key), "=", val != key ? e(val) : "");
                });
            }
            if (!pre) {
                buf.shift();
                pre = "";
            }
            return pre + buf.join('');
        },
        urlDecode : function(string, overwrite) {
            var obj = {},
                    pairs = string.split('&'),
                    d = decodeURIComponent,
                    name,
                    value;
            Ccs.each(pairs, function(pair) {
                pair = pair.split('=');
                name = d(pair[0]);
                value = d(pair[1]);
                obj[name] = overwrite || !obj[name] ? value :
                            [].concat(obj[name]).concat(value);
            });
            return obj;
        },
        toArray : function() {
            return isIE ?
                   function(a, i, j, res) {
                       res = [];
                       Ccs.each(a, function(v) {
                           res.push(v);
                       });
                       return res.slice(i || 0, j || res.length);
                   } :
                   function(a, i, j) {
                       return Array.prototype.slice.call(a, i || 0, j || a.length);
                   };
        }(),
        each : function(obj, fn, scope) {
            if (obj === null || obj === undefined)
                return;
            var type = typeof obj;
            if (type == "string" || type == "boolean" || type == "number") {
                obj = [obj];
            }
            if (typeof obj.length == "number" && typeof obj[0] != "undefined") {
                for (var i = 0, len = obj.length; i < len; i++) {
                    if (fn.call(scope || obj[i], obj[i], i, obj) === false) {
                        return i;
                    }
                }
                return;
            }
            if (typeof obj.nodeType == "undefined") {
                for (var name in obj)
                    if (fn.call(scope || obj[name], obj[name], name, obj) === false)
                        break;
            }
        },
        invoke : function(arr, methodName) {
            var ret = [],args = Array.prototype.slice.call(arguments, 2);
            Ccs.each(arr, function(v) {
                if (v && typeof v[methodName] == "function") {
                    ret.push(v[methodName].apply(v, args));
                } else {
                    ret.push(undefined);
                }
            });
            return ret;
        },
        removeNode : isIE ? function() {
            var d;
            return function(n) {
                if (n && n.tagName != 'BODY') {
                    d = d || document.createElement('div');
                    d.appendChild(n);
                    d.innerHTML = '';
                }
            };
        }() : function(n) {
            if (n && n.parentNode && n.tagName != 'BODY') {
                n.parentNode.removeChild(n);
            }
        },
        isEmpty : function(v, allowBlank) {
            return v === null || v === undefined || ((Ccs.isArray(v) && !v.length)) || (!allowBlank ? v === '' : false);
        },
        isArray : function(v) {
            return Object.prototype.toString.apply(v) === '[object Array]';
        },
        isObject : function(v) {
            return v && typeof v == "object";
        },
        isFunction : function(v) {
            return typeof v == "function";
        },
        isDate : function(v) {
            return Object.prototype.toString.apply(v) === '[object Date]';
        },
        isIE : isIE,
        isIE6 : isIE && !isIE7 && !isIE8,
        isIE7 : isIE7,
        isIE8 : isIE8,
        escapeRe : function(s) {
            return s.replace(/([.*+?^${}()|[\]\/\\])/g, "\\$1");
        }
    });
    Ccs.ns = Ccs.namespace;
})();

Ccs.ns("Ccs", "Ccs.lib", "Ccs.util", "Ccs.widget", "Ccs.app");

Ccs.apply(Function.prototype, {
    createInterceptor : function(fcn, scope) {
        var method = this;
        return !Ccs.isFunction(fcn) ?
               this :
               function() {
                   var me = this,
                           args = arguments;
                   fcn.target = me;
                   fcn.method = method;
                   return (fcn.apply(scope || me || window, args) !== false) ?
                          method.apply(me || window, args) :
                          null;
               };
    },
    createCallback : function() {
        var args = arguments,
                method = this;
        return function() {
            return method.apply(window, args);
        };
    },
    createDelegate : function(obj, args, appendArgs) {
        var method = this;
        return function() {
            var callArgs = args || arguments;
            if (appendArgs === true) {
                callArgs = Array.prototype.slice.call(arguments, 0);
                callArgs = callArgs.concat(args);
            } else if (typeof appendArgs == "number") {
                callArgs = Array.prototype.slice.call(arguments, 0);
                var applyArgs = [appendArgs, 0].concat(args);
                Array.prototype.splice.apply(callArgs, applyArgs);
            }
            return method.apply(obj || window, callArgs);
        };
    },
    defer : function(millis, obj, args, appendArgs) {
        var fn = this.createDelegate(obj, args, appendArgs);
        if (millis > 0) {
            return setTimeout(fn, millis);
        }
        fn();
        return 0;
    }
});

Ccs.applyIf(String, {
    trim:function() {
        var re = /^\s+|\s+$/g;
        return function() {
            return this.replace(re, "");
        };
    },
    format : function(format) {
        var args = Ccs.toArray(arguments, 1);
        return format.replace(/\{(\d+)\}/g, function(m, i) {
            return args[i];
        });
    },
    escape : function(string) {
        return string.replace(/('|\\)/g, "\\$1");
    },
    leftPad : function (val, size, ch) {
        var result = String(val);
        if (!ch) {
            ch = " ";
        }
        while (result.length < size) {
            result = ch + result;
        }
        return result;
    }
});

Date.prototype.getElapsed = function(date) {
    return Math.abs((date || new Date()).getTime() - this.getTime());
};

Ccs.applyIf(Array.prototype, {
    indexOf : function(o) {
        for (var i = 0, len = this.length; i < len; i++) {
            if (this[i] == o) return i;
        }
        return -1;
    },
    remove : function(o) {
        var index = this.indexOf(o);
        if (index != -1) {
            this.splice(index, 1);
        }
        return this;
    }
});
