/**
 * app calendar script
 * <p/>
 *
 * @author <a href="mailto:oznyang@163.com">oznyang</a>
 * @version V1.0, 2009-5-21 10:43:09
 */

/**
 * 日历应用类
 * @cfg {boolean} isCalManage 是否管理模式
 */
Ccs.app.Calendar = function(cfg) {
    /*
     this.isCalManage = false;
     this.isManager = false;
     this.isStandard = false;
     this.groupId = null;
     this.userId = null;
     */
    Ccs.apply(this, cfg);
    this.canManage = this.isManager || typeof this.isManager == 'undefined';
    this.init();
};

Ccs.app.Calendar.prototype = {
    defColors:["#668CB3","#6633CC","#336699","#3366CC","#22AA99","#329262","#109618","#66AA00","#AAAA11","#D6AE00","#EE8800","#DD5511","#A87070","#8C6D8C","#627487","#7083A8","#5C8D87","#898951","#B08B59","#CC3333","#DD4477","#994499"],
    calTypes:{
        PRIVATE:0,  //个人私有日历
        PRIMARY:1,  //个人私有默认日历,不能删除
        PROTECTED:2,//个人日历,不能修改
        FRIEND:3,   //好友可见日历，能够被好友看到
        PUBLIC:4,   //公开日历，能够被检索
        STANDARD:5, //标准日历，如农历节假日，能够被检索
        GROUP:6     //群组日历，群组成员可见，群组管理员可修改
    },
    /**
     * 初始化日历
     */
    init:function() {
        var h = location.href.split('#'),p = h[0].split('?');
        this.baseUrl = p[0];
        this.param = p[1] ? Ccs.urlDecode(p[1]) : {};
        if (h[1])
            Ccs.apply(this.param, Ccs.urlDecode(decodeURIComponent(h[1])));
        this.updateCalMap();
        this.ct = Ccs(this.id || 'cal-container');
        if (this.viewport)
            this.ct.setStyle('height', (Ccs.Dom.getViewportHeight() - 5) + 'px');
        if (this.isCalManage) {//日历管理页面用
            this.calList = Ccs(this.calId || 'cal-list');
            this.calTpl = Ccs.tpl.from('manageCalTpl');
            this.renderCals();
            return;
        }
        this.now = new Date();
        var t = this.param['__t'];
        this.time = t ? new Date(parseInt(t)) : this.now;
        this.height = this.ct.dom.offsetHeight;
        this.darkColors = {};
        for (var i = 0; i < this.defColors.length; i++) {
            this.darkColors[this.defColors[i]] = this.getDarkColor(this.defColors[i]);
        }
        this.updateContainer();
        if (this.viewOnly) {
            this.updateEventMap();
            this.renderEvents();
        } else {
            this.calList = Ccs(this.calId || 'cal-list');
            this.renderCals();
            this.initCalendarNav();
            this.initTimeView();
            this.reload();
        }
        setInterval(this.reload.createDelegate(this), (this.delay || 60) * 1000);
    },
    /**
     * 初始化时间显示
     */
    initTimeView:function() {
        var calTime = Ccs('cal-time');
        if (calTime) {
            var updateTime = function() {
                calTime.html((new Date()).format('Y年j月n日 G时i分'));
            };
            updateTime();
            setInterval(updateTime, 6e4);
        }
    },
    /**
     * 初始化日期选择器
     */
    initCalendarNav:function() {
        var self = this,cal;
        var navConfig = {
            strings : {
                month: "选择月:",
                year: "选择年:",
                submit: "确定",
                cancel: "取消",
                invalidYear: "请输入有效年份"
            },
            monthFormat: YAHOO.widget.Calendar.SHORT,
            initialFocus: "year"
        };
        this.navCal = cal = new YAHOO.widget.Calendar("cal-div", {navigator:navConfig});
        cal.render();
        cal.selectEvent.subscribe(function(type, args) {
            var selDate = args[0][0];
            self.reload({'d':new Date(selDate[0], selDate[1] - 1, selDate[2])});
        });
        cal.renderEvent.subscribe(function() {
            var pagedate = cal.cfg.getProperty('pagedate');
            if (!self.isSameMonth(pagedate, self.time))
                self.reload({'d':pagedate});
        });
    },
    /**
     * 更新日期选择器状态
     */
    updateCalendarNav:function() {
        if (!this.navCal)
            return;
        this.navCal.removeRenderers();
        this.navCal.addRenderer(this.days[0].format('n/j'), this.navCal.renderCellStyleSelected);
        if (this.step < 20)
            this.navCal.addRenderer(this.days[1].format('n/j/Y') + '-' + this.days[this.step - 1].format('n/j/Y'), this.navCal.renderCellStyleHighlight1);
        for (var d in this.hasEventDays) {
            this.navCal.addRenderer(d, function(wd, cell) {
                YAHOO.util.Dom.addClass(cell, 'hasEvent');
            });
        }
        this.navCal.cfg.setProperty('pagedate', this.time.format('n/Y'));
        this.navCal.render();
    },
    /**
     * 刷新日历窗体
     */
    updateContainer:function() {
        this.getViewDays();
        this.cleanEvents();
        if (!this.containerTpl)
            this.containerTpl = Ccs.tpl.from('containerTpl');
        Ccs.DomHelper.overwrite(this.ct, this.containerTpl.process({days:this.days,now:this.now,height:this.height,mode:this.param['mode'],viewOnly:this.viewOnly}));
    },
    /**
     * 获取要展示的日期列表
     */
    getViewDays:function() {
        var mode = this.param['mode'],sd,ed;
        this.days = [];
        if (mode == 'month') {
            sd = this.time.getFirstDateOfMonth();
            ed = this.time.getLastDateOfMonth();
            sd.setHours(this.time.getHours(), this.time.getMinutes());
            ed.setHours(this.time.getHours(), this.time.getMinutes());
            sd = sd.add(Date.DAY, -sd.getDay() + 1);
            if (ed.getDay() != 0)
                ed = ed.add(Date.DAY, 7 - ed.getDay());
            this.step = this.time.getDaysInMonth();
        } else {
            this.step = mode == 'list' ? 15 : 5;
            sd = this.time;
            ed = this.time.add(Date.DAY, this.step - 1);
        }
        for (var day = sd; day.between(sd, ed); day = day.add(Date.DAY, 1))
            this.days.push(day);
    },
    /**
     * ajax重载日历列表
     */
    reloadCals:function() {
        if (!this.calList)
            return;
        var self = this;
        Ccs.request({
            url:this.baseUrl,
            params:Ccs.apply({'__cal':true}, this.param),
            success: function(res) {
                var cals = Ccs.decode(res.responseText) || [];
                if (!self.isCalManage && self.hasDifferentCal(cals))
                    self.reload();
                self.calendars = cals;
                self.updateCalMap();
                self.renderCals();
            }
        });
    },
    /**
     * ajax重载事件
     * @param cfg 配置对象，t为类型，0现在，-1上一个单位时间，1下一个单位时间。d为具体跳转到的时间，mode为展示模式，空为强制刷新
     */
    reload:function(cfg) {
        var t1 = this.time;
        if (cfg) {
            var t = cfg['t'],d = cfg['d'];
            if (t == 0)
                this.time = new Date();
            else if (!isNaN(t))
                this.time = this.time.add(Date.DAY, this.step * t);
            else if (d) {
                d.setHours(this.now.getHours(), this.now.getMinutes(), this.now.getSeconds());
                this.time = d;
            }
            if (cfg['mode'])
                this.param['mode'] = cfg['mode'];
        }
        var sd = this.time.getFirstDateOfMonth();
        var ed = this.time.getLastDateOfMonth();
        sd = sd.add(Date.DAY, 1 - sd.getDay());
        if (ed.getDay() != 0)
            ed = ed.add(Date.DAY, 7 - ed.getDay());
        var sed = this.time.add(Date.DAY, 14);
        ed = ed.getTime() > sed.getTime() ? ed : sed;
        Ccs.apply(this.param, {'__s':sd.format('Y-m-d'),'__e':ed.format('Y-m-d')});
        location.hash = encodeURIComponent('mode=' + (this.param['mode'] || '') + '&__t=' + this.time.getTime());
        if (cfg && this.isSameMonth(t1, this.time)) {
            this.updateContainer();
            this.renderEvents();
        } else {
            var self = this;
            Ccs.request({
                url:this.baseUrl,
                params:Ccs.apply({'__json':true}, this.param),
                success: function(res) {
                    var events = Ccs.decode(res.responseText) || [];
                    if (cfg || self.hasDifferentEvent(events)) {
                        if (cfg)
                            self.updateContainer();
                        else
                            self.cleanEvents();
                        self.events = events;
                        self.updateEventMap();
                        self.renderEvents();
                    }
                }
            });
        }
        return false;
    },
    /**
     * 清除界面所有事件
     */
    cleanEvents:function() {
        var es = this.ct.query('.cal-event,.cal-event-wholeDay');
        if (es && es.length != 0)
            es.each(function(e) {
                e.unClick(this.showTip);
                e.remove();
            });
    },
    /**
     * 清除界面所有日历
     */
    cleanCals:function() {
        var cals = this.calList.query('.p-cal-item');
        if (cals && cals.length != 0)
            cals.each(function(c) {
                c.remove();
            });
    },
    /**
     * 渲染日历列表
     */
    renderCals:function() {
        this.cleanCals();
        if (!this.calTpl)
            this.calTpl = Ccs.tpl.from('calTpl');
        for (var i = 0; i < this.calendars.length; i++) {
            var cal = this.calendars[i];
            var ct = Ccs.getDom('cal-list-' + this.getCalType(cal));
            if (ct) {
                if (this.isCalManage) {
                    cal['canDelete'] = cal.type < this.calTypes.STANDARD && cal.type != this.calTypes.PRIMARY;
                    Ccs.DomHelper.insertAfter(ct, this.calTpl.process(cal));
                } else
                    Ccs.DomHelper.append(ct, this.calTpl.process(cal));
            }
        }
    },
    /**
     * 渲染所有事件
     */
    renderEvents:function() {
        this.hasEventDays = {};
        if (!this.eventTpl) {
            this.eventTpl = Ccs.tpl.from('eventTpl');
            this.listEventTpl = Ccs.tpl.from('listEventTpl');
        }
        for (var i = 0; i < this.events.length; i++)
            this.renderEvent(this.events[i]);
        this.updateCalendarNav();
    },
    /**
     * 渲染一个事件
     * @param event 事件
     */
    renderEvent:function(event) {
        Ccs.apply(event, {
            darkColor:this.darkColors[(event['color'])],
            lock:!this.viewOnly && !this.isManager && event['creator'] != this.userId,
            viewOnly:this.viewOnly || !this.isManager && event['creator'] != this.userId
        });
        var events = this.getSingleDayEvents(event);
        for (var i = 0; i < events.length; i++) {
            var e = events[i],startTime = new Date(e['startTime']),col = Ccs.getDom('dayCol-' + startTime.getMonth() + '-' + startTime.getDate()),afterNode,el;
            this.hasEventDays[(startTime.getMonth() + 1) + '/' + startTime.getDate()] = true;
            if (col) {
                var html = this.param['mode'] == 'list' ? this.listEventTpl.process(e) : this.eventTpl.process(e);
                if (e['wholeDay'])
                    el = Ccs.DomHelper.insertFirst(col, html);
                else {
                    for (var j = 0; j < col.childNodes.length; j++) {
                        var node = col.childNodes[j];
                        if (!node.tagName)
                            continue;
                        var tid = node.getAttribute('tid');
                        if (tid && e['startTime'] < parseInt(tid.substr(2))) {
                            afterNode = node;
                            break;
                        }
                    }
                    if (afterNode)
                        el = Ccs.DomHelper.insertBefore(afterNode, html);
                    else
                        el = Ccs.DomHelper.append(col, html);
                }
                if (Ccs.isIE)
                    Ccs(el).setStyle('width', (el.offsetWidth - 2) + 'px');
                Ccs(el).click(this.showTip, event, this);
            }
        }
    },
    /**
     * 刷新事件map，用来更具hash快速访问事件
     */
    updateEventMap:function() {
        this.eventMap = {};
        for (var i = 0; i < this.events.length; i++) {
            var event = this.events[i];
            this.eventMap[event['hashCode']] = event;
        }
    },
    /**
     * 刷新日历列表，用来根据个人日历Id和基本日历Id快速访问日历
     */
    updateCalMap:function() {
        this.calMap = {};
        this.pCalMap = {};
        for (var i = 0; i < this.calendars.length; i++) {
            var cal = this.calendars[i];
            this.pCalMap[cal.id] = this.calMap[cal.calendarId] = cal;
        }
    },
    /**
     * 检测事件列表是否有变化
     * @param events 时间列表
     */
    hasDifferentEvent:function(events) {
        if (!this.eventMap || !events || events.length == 0)
            return true;
        for (var i = 0; i < events.length; i++) {
            var event = events[i];
            if (!this.eventMap[event['hashCode']])
                return true;
        }
        return this.events.length != events.length;
    },
    /**
     * 检测日历列表是否有变化
     * @param cals 日历列表
     */
    hasDifferentCal:function(cals) {
        if (!cals || cals.length == 0)
            return true;
        for (var i = 0; i < cals.length; i++) {
            var cal = cals[i];
            if (!this.pCalMap[cal.id] || this.pCalMap[cal.id]['selected'] != cal['selected'] || this.pCalMap[cal.id]['color'] != cal['color'])
                return true;
        }
        return this.calendars.length != cals.length;
    },
    /**
     * 是否同年同一个月份
     * @param d
     * @param d1
     */
    isSameMonth:function(d, d1) {
        return d.getMonth() == d1.getMonth() && d.getYear() == d1.getYear();
    },
    /**
     * 获取颜色的深色，用来做标题
     * @param color 颜色
     */
    getDarkColor:function() {
        function dark(v, alpha) {
            return String.leftPad(Math.floor(parseInt(v, 16) * alpha).toString(16), 2, '0');
        }

        var alpha = 0.8;
        return function(color) {
            return '#' + dark(color.substr(1, 2), alpha) + dark(color.substr(3, 2), alpha) + dark(color.substr(5, 2), alpha);
        };
    }(),
    /**
     * 将跨天时间分解为单天事件展示
     * @param event 事件
     */
    getSingleDayEvents:function(event) {
        var events = [],sd = new Date(event['startTime']),ed = new Date(event['endTime']),sde = sd.clone();
        if (event['wholeDay'])
            events.push(event);
        else
            for (sde.setHours(24, 0, 0); sd.getTime() < ed.getTime(); sd = sde,sde = sde.add(Date.DAY, 1)) {
                if (sde.getTime() > ed.getTime())
                    sde = ed;
                events.push(Ccs.applyIf({
                    startTime:sd.getTime(),
                    endTime:sde.getTime(),
                    wholeDay:sd.add(Date.DAY, 1).getTime() == sde.getTime()
                }, event));
            }
        return events;
    },
    /**
     * 获取日历类型
     * @param cal 个人日历
     */
    getCalType:function(cal) {
        var type = "";
        if (this.isStandard && cal.type == this.calTypes.STANDARD) {
            type = 'standard';
        } else if (cal['admin'] && cal.type < this.calTypes.STANDARD) {
            type = 'personal';
        } else if (cal.type == this.calTypes.GROUP) {
            type = 'group';
        } else if (cal.type == this.calTypes.FRIEND || cal.type == this.calTypes.PUBLIC || cal.type == this.calTypes.STANDARD) {
            type = 'other';
        }
        return type;
    },
    /**
     * 获取能管理的日历列表
     */
    getEditableCals:function() {
        if (this.isManager)
            return this.calendars;
        var cals = [];
        for (var i = 0; i < this.calendars.length; i++) {
            var cal = this.calendars[i];
            if (this.getCalType(cal) == 'personal')
                cals.push(cal);
        }
        return cals;
    },
    /**
     * 显示事件tip
     * @param e dom事件
     * @param event 事件
     */
    showTip:function(e, event) {
        event['calendar'] = this.calMap[event['calendarId']];
        if (!this.tipTpl)
            this.tipTpl = Ccs.tpl.from('tipTpl');
        if (!this.calTip)
            this.calTip = new Ccs.widget.CalTip({showCloseBtn:true});
        this.calTip.setHtml(this.tipTpl.process(event));
        this.calTip.show(Ccs.Event.getXY(e));
        Ccs.Event.stopEvent(e);
    },
    /**
     * 编辑事件
     * @param cfg 对象，time为默认时间，calId为添加到的默认日历，hash为一个事件的hash值
     */
    editEvent:function(cfg) {
        if (!this.canManage)
            return;
        if (!cfg)
            cfg = {};
        var event = this.eventMap[cfg.hash];
        if (!event) {
            var t = cfg['time'] ? cfg['time'] : this.time.getTime();
            event = {"calendarId":cfg.calId,"description":null,"startTime":t,"endTime":t + 3.6e6,"id":null,"location":null,"recurrenceRule":null,"repeatEndTime":null,"title":null,"updateTime":null,"url":null,"wholeDay":false};
        }
        event['groupId'] = this.groupId;
        event['isStandard'] = this.isStandard;
        event.calendars = this.getEditableCals();
        var getBetweenStr = function(a, b, c) {
            var i = a.indexOf(b);
            if (i > -1) {
                var j = a.indexOf(c, i);
                return a.substring(i + b.length, j == -1 ? a.length : j);
            }
        };
        if (!this.eventDg) {
            this.eventDg = new HN.widget.Dialog({"class":"dialog-2", id:"eventFormDg", modal:true, close:true});
            this.eventDg.onShow.subscribe(function () {
                this.setXCenter();
                this.setY(YAHOO.util.Dom.getDocumentScrollTop() + 125);
            }, this.eventDg, true);
        }
        this.eventDg.setHeader("<h3>" + (!cfg.id ? "创建" : "修改") + "任务</h3>");
        if (!this.eventFormTpl)
            this.eventFormTpl = Ccs.tpl.from('eventFormTpl');
        this.eventDg.setBody(this.eventFormTpl.process(event));
        if (!this.remindersTpl)
            this.remindersTpl = Ccs.tpl.from('remindersTpl');
        if (event.id)
            Ccs.request({
                url:'reminders.do',
                params:{'eventId':event.id},
                success: function(o) {
                    var reminders = Ccs.decode(o.responseText);
                    if (reminders && reminders.length > 0)
                        for (var i = 0; i < reminders.length; i++)
                            Ccs.DomHelper.insertBefore('addReminder', self.remindersTpl.process(reminders[i]));
                }
            });
        this.eventDg.setFooter('<p class="act"><input type="button" class="f-button" value="确定" id="event-submit"/><input type="button" class="f-button f-alt close" value="取消"/></p>');
        var self = this;
        Ccs.on("event-submit", "click", function() {
            var form = Ccs.getDom('eventForm');
            if (form.title.value.length == 0) {
                HN.cst.CMNFUNCS.setAlertDialog('内容不得为空');
                return;
            } else if (form.calendarId.value.length == 0) {
                HN.cst.CMNFUNCS.setAlertDialog('请选择计划，如果是第一次添加，请先创建一个计划');
                return;
            } else if (form.startTime.value.length == 0) {
                HN.cst.CMNFUNCS.setAlertDialog('开始时间不得为空');
                return;
            } else if (!form.wholeDay.checked && form.endTime.value.length == 0) {
                HN.cst.CMNFUNCS.setAlertDialog('结束时间不得为空');
                return;
            } else if (!form.wholeDay.checked) {
                var startTime = Date.parseDate(form.startTime.value, 'Y-m-d H:i');
                var endTime = Date.parseDate(form.endTime.value, 'Y-m-d H:i');
                if (endTime.getTime() < startTime.getTime()) {
                    HN.cst.CMNFUNCS.setAlertDialog('结束时间不得小于开始时间');
                    return;
                }
            }
            Ccs.Connect.setForm(form, false);
            var ca = Ccs.Connect.asyncRequest("POST", "editEvent.do", {
                success:function (o) {
                    var res = Ccs.decode(o.responseText);
                    self.eventDg.hide();
                    if (res && res.status == 1)
                        self.reload();
                    else
                        HN.cst.CMNFUNCS.setAlertDialog(HN.cst.MSG.ASYNC_DATA_ERROR);
                }
            });
            if (Ccs.Connect.isCallInProgress(ca)) {
                self.eventDg.setBody(HN.cst.MSG.LOADING_DIV);
                self.eventDg.setFooter("");
            }
        });
        this.eventDg.show();
        var form = Ccs.getDom('eventForm');
        form.title.focus();
        if (event.recurrenceRule) {
            form.interval.value = getBetweenStr(event.recurrenceRule, 'INTERVAL=', ';');
            form.recurType.value = getBetweenStr(event.recurrenceRule, 'FREQ=', ';');
            if (form.recurType.value == 'WEEKLY')
                form.recurType.nextSibling.style.display = '';
            var day = getBetweenStr(event.recurrenceRule, 'BYDAY=', ';');
            if (day)
                Ccs.each(document.getElementsByName('byday'), function(input) {
                    if (day.indexOf(input.value) > -1)
                        input.checked = 'checked';
                });
        }
        new Ccs.widget.DateField('startTime', {value:this.days[0]});
        new Ccs.widget.DateField('endTime', {value:this.days[0]});
        new Ccs.widget.DateField('repeatEndTime', {value:this.days[0]});
        return false;
    },
    /**
     * 添加一个提醒
     * @param a 传过来的对象
     */
    addReminder:function(a) {
        var reminder = {id:Ccs.id(),method:2,number:10,unit:60};
        Ccs.DomHelper.insertBefore(a, this.remindersTpl.process(reminder));
    },
    /**
     * 删除事件，
     * @param id 事件id
     */
    delEvent:function(id) {
        if (!this.eventDelDg) {
            this.eventDelDg = new HN.widget.Dialog({"class":"dialog-2", id:"eventDelDg", modal:true, close:true});
            this.eventDelDg.onShow.subscribe(function () {
                this.setXCenter();
                this.setY(YAHOO.util.Dom.getDocumentScrollTop() + 150);
            }, this.eventDelDg, true);
            this.eventDelDg.setHeader("<h3>删除任务</h3>");
            this.eventDelDg.setBody("您确定要删除这个任务吗？");
        }
        var self = this;
        this.eventDelDg.setFooter('<p class="act"><input type="button" class="f-button" value="确定" id="event-del-submit"/><input type="button" class="f-button f-alt close" value="取消"/></p>');
        Ccs.on("event-del-submit", "click", function() {
            Ccs.request({
                url:'delEvent.do',
                params:{'id':id},
                success: function() {
                    self.eventDelDg.hide();
                    self.reload();
                }
            });
        });
        this.eventDelDg.show();
        return false;
    },
    /**
     * 删除日历
     * @param id 日历id
     */
    delCalendar:function(id) {
        if (!this.calDelDg) {
            this.calDelDg = new HN.widget.Dialog({"class":"dialog-2", id:"calDelDg", modal:true, close:true});
            this.calDelDg.onShow.subscribe(function () {
                this.setXCenter();
                this.setY(YAHOO.util.Dom.getDocumentScrollTop() + 150);
            }, this.calDelDg, true);
            this.calDelDg.setHeader("<h3>删除计划</h3>");
            this.calDelDg.setBody("您确定要删除这个计划吗？");
        }
        var self = this;
        this.calDelDg.setFooter('<p class="act"><input type="button" class="f-button" value="确定" id="cal-del-submit"/><input type="button" class="f-button f-alt close" value="取消"/></p>');
        Ccs.on("cal-del-submit", "click", function() {
            Ccs.request({
                url:'delCal.do',
                params:{'id':id},
                success: function() {
                    self.calDelDg.hide();
                    self.reloadCals();
                }
            });
        });
        this.calDelDg.show();
        return false;
    },
    /**
     * 编辑日历
     * @param id 日历id
     */
    editCalendar:function(id) {
        var calendar = this.pCalMap[id];
        if (!calendar) {
            calendar = {"name":null,"description":null,"color":null,id:null,type:0,creator:null,calendarCreator:null};
        }
        calendar['colors'] = this.defColors;
        calendar['isStandard'] = this.isStandard;
        calendar['groupId'] = this.groupId;
        calendar['isManager'] = this.isManager || !calendar.id || this.getCalType(calendar) == 'personal';
        if (!this.calDg) {
            this.calDg = new HN.widget.Dialog({"class":"dialog-2", id:"eventFormDg", modal:true, close:true});
            this.calDg.onShow.subscribe(function () {
                this.setXCenter();
                this.setY(YAHOO.util.Dom.getDocumentScrollTop() + 125);
            }, this.calDg, true);
        }
        this.calDg.setHeader("<h3>" + (!id ? "创建" : "修改") + "计划</h3>");
        if (!this.calendarFormTpl)
            this.calendarFormTpl = Ccs.tpl.from('calendarFormTpl');
        this.calDg.setBody(this.calendarFormTpl.process(calendar));
        this.calDg.setFooter('<p class="act"><input type="button" class="f-button" value="确定" id="cal-submit"/><input type="button" class="f-button f-alt close" value="取消"/></p>');
        var self = this;
        Ccs.on("cal-submit", "click", function() {
            var form = Ccs.getDom('calendarForm');
            form.name.disabled = '';
            if (form.name.value.length == 0) {
                HN.cst.CMNFUNCS.setAlertDialog('计划名不得为空');
                return;
            }
            form.description.disabled = '';
            Ccs.Connect.setForm(form, false);
            var ca = Ccs.Connect.asyncRequest("POST", "editCalendar.do", {
                success:function (o) {
                    var res = Ccs.decode(o.responseText);
                    self.calDg.hide();
                    if (res && res.status == 1)
                        self.reloadCals();
                    else
                        HN.cst.CMNFUNCS.setAlertDialog(HN.cst.MSG.ASYNC_DATA_ERROR);
                }
            });
            if (Ccs.Connect.isCallInProgress(ca)) {
                self.calDg.setBody(HN.cst.MSG.LOADING_DIV);
                self.calDg.setFooter("");
            }
        });
        this.calDg.show();
        var color = Ccs.getDom('cal-color');
        color.style.backgroundColor = color.value;
        var form = Ccs.getDom('calendarForm');
        if (!form.name.disabled)form.name.focus();
        return false;
    },
    /**
     * 切换日历状态
     * @param box
     */
    toggleCalendar:function(box) {
        var self = this;
        Ccs.request({
            url:'toggleCalendar.do',
            params:{type:box.name,checked:!!box.checked,id:box.value},
            success: function() {
                self.reloadCals();
            }
        });
    },
    /**
     * 选中某个日历，去掉其他日历的选择
     * @param id
     */
    selectCalendar:function(id) {
        var self = this;
        var oid = [];
        Ccs.each(this.calendars, function(cal) {
            if (cal.id != id)
                oid.push(cal.id);
        });
        Ccs.request({
            url:'selectCalendar.do',
            params:{id:id,oId:oid},
            success: function() {
                self.reloadCals();
            }
        });
    },
    /**
     * 导入日历
     */
    importCalendar:function() {
        if (!this.importDg) {
            this.importDg = new HN.widget.Dialog({"class":"dialog-2", id:"importFormDg", modal:true, close:true});
            this.importDg.onShow.subscribe(function () {
                this.setXCenter();
                this.setY(YAHOO.util.Dom.getDocumentScrollTop() + 125);
            }, this.importDg, true);
            this.importDg.setFooter('<p class="act"><input type="button" class="f-button" value="导入" id="cal-import-submit"/><input type="button" class="f-button f-alt close" value="取消"/></p>');
            var self = this;
            Ccs.on("cal-import-submit", "click", function() {
                var form = Ccs.getDom('importForm');
                if (form.file.value.length == 0) {
                    HN.cst.CMNFUNCS.setAlertDialog('请选择要导入的文件');
                    return;
                }
                self.importDg.setFooter("");
                form.submit();
            });
        }
        this.importDg.setHeader("<h3>导入计划</h3>");
        if (!this.importFormTpl)
            this.importFormTpl = Ccs.tpl.from('importFormTpl');
        this.importDg.setBody(this.importFormTpl.process(this.getEditableCals()));
        this.importDg.show();
        return false;
    },
    /**
     * 显示日历菜单
     * @param e dom事件
     * @param id 日历id
     */
    showCalMenu:function(e, id) {
        var calendar = this.pCalMap[id];
        calendar['canHide'] = !this.groupId && !this.isStandard && calendar.type != this.calTypes.PRIMARY;
        var calType = this.getCalType(calendar);
        calendar['canDelete'] = this.isManager || calendar.type < this.calTypes.STANDARD && calendar.type != this.calTypes.PRIMARY;
        calendar['canManage'] = this.isManager || this.getCalType(calendar) == 'personal';
        var el = Ccs(Ccs.Event.getTarget(e));
        if (!this.calMenuTpl)
            this.calMenuTpl = Ccs.tpl.from('calMenuTpl');
        if (!this.calMenu)
            this.calMenu = new Ccs.widget.CalMenu();
        this.calMenu.setHtml(this.calMenuTpl.process(calendar));
        this.calMenu.show(el);
        Ccs.Event.stopEvent(e);
        return false;
    }
};

/**
 * 日历菜单类
 * @param config 初始化参数
 */
Ccs.widget.CalMenu = function(config) {
    Ccs.apply(this, config);
    this.ct = null;
};

Ccs.widget.CalMenu.prototype = {
    init:function() {
        var html = '<div class="cal-menu" style="display:none;"></div>';
        this.ct = Ccs.DomHelper.append(document.body, html, true);
    },
    show:function(el) {
        this.ct.show();
        var xy = el.getXY();
        this.ct.setXY([xy[0] - this.ct.dom.offsetWidth + el.dom.offsetWidth,xy[1] + el.dom.offsetHeight + 4]);
        Ccs().click(this.hide, this, true);
    },
    hide:function() {
        this.ct.hide();
        Ccs().unClick(this.hide);
    },
    setHtml:function(html) {
        if (!this.ct) {
            this.init();
        }
        this.ct.html(html);
    }
};

/**
 * 日历tip类
 * @param config 初始化参数
 */
Ccs.widget.CalTip = function(config) {
    Ccs.apply(this, config);
    this.ct = null;
};

Ccs.widget.CalTip.prototype = {
    init:function() {
        var html = ['<div class="cal-tip" style="display:none;"><div class="top"></div><div class="bottom withCorner"></div><div class="ct"></div>',this.showCloseBtn ? '<div class="close" onclick="this.parentNode.style.display=\'none\';"></div>' : '','</div>'].join('');
        this.ct = Ccs.DomHelper.append(document.body, html, true);
        this.body = this.ct.query('.ct').first();
    },
    show:function(xy) {
        this.ct.show();
        this.ct.setStyle('height', (this.body.dom.offsetHeight + 11) + 'px');
        var x = xy[0]-49;
        var vp=Ccs.Dom.getViewportWidth();
        if (x < 0)
            x = 5;
        if (x + this.body.dom.offsetWidth > vp)
            x = vp - this.body.dom.offsetWidth - 30;
        var y = xy[1] - this.ct.dom.offsetHeight - 12;
        this.ct.setXY([x,y < 0 ? 5 : y]);
        Ccs().click(this.hide, this, true);
    },
    hide:function(e) {
        var el = Ccs(Ccs.Event.getTarget(e));
        if ((!el.findParent('.cal-tip') || el.test('.cal-tip .bottom')) || el.test('.cal-tip a,.cal-tip input[type=button],.cal-tip input[type=submit]')) {
            this.ct.hide();
            Ccs().unClick(this.hide);
        }
    },
    setHtml:function(html) {
        if (!this.ct) {
            this.init();
        }
        this.body.html(html);
    }
};

Ccs.app.Calendar.calSearch = function(id) {
    var f = Ccs.getDom('cal-search');
    f.type.value = id;
    f.submit();
    return false;
};

Ccs.app.Calendar.doAction = function(url) {
    location.href = url + (url.indexOf('?') ? '&__bUrl=' : '?__bUrl=') + escape(location.href);
    return false;
};

Ccs.app.Calendar.initDelete = function() {
    var delLink = new HN.widget.LinkPost(function(el) {
        return YAHOO.util.Dom.hasClass(el, "delete-cal");
    }, {
        r0: "minifeedid"
    }, {
        hd: "",
        bd: HN.cst.MSG.CONFORM_DEL.replace(/%s/, "计划"),
        ft: HN.cst.MSG.POST_DEL_FOOTER
    }, "cal-list");
    delLink.afterPost.subscribe(function() {
        HN.cst.CMNFUNCS.yFadeRemove(this.link, 'tr');
    });
};




