<%@ page pageEncoding="utf-8" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt" %>
<%@ taglib prefix="fn" uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="spring" uri="http://www.springframework.org/tags" %>
<textarea class="jst-tpl" id="calendarFormTpl">
    <form id="calendarForm"><input type="hidden" name="calendarId" value="\${id}"/>
        <table class="form-layout cal-form-tb" style="margin:0;">
            <tbody>
            <tr>
                <th><spring:message code="calendar.template.calendar.name" /></th>
                <td><input type="text" class="f-text" maxlength="50" name="name" value="\${name}"/></td>
            </tr>
            <tr>
                <th><spring:message code="calendar.template.calendar.description" /></th>
                <td><input type="text" class="f-text" maxlength="50" name="description" value="\${description}"{if !isManager} disabled="disabled"{/if}/></td>
            </tr>
            <tr>
                <th><spring:message code="calendar.template.calendar.color" /></th>
                <td><select name="color" id="cal-color" class="f-text" onchange="this.style.backgroundColor=this.value;"
                            style="background:#fff;border:1px solid #999;font-size:14px;">
                    {for col in colors}
                    <option value="\${col}" style="background:\${col}"{if col==color} selected="selected"{/if}></option>
                    {/for}
                </select></td>
            </tr>
            {if isStandard || type==5}<input type="hidden" name="type" value="5"/>{elseif groupId || type==6}<input type="hidden" name="type" value="6"/>{if groupId}<input type="hidden" name="owner" value="\${groupId}"/>{/if}{elseif creator==calendarCreator}<%--<tr>
                <th><spring:message code="calendar.template.calendar.shareState" /></th>
                <td>
                    <input value="0" id="cal-0" type="radio" name="type" class="cal-check"{if type==0} checked="checked"{/if}/><label for="cal-0"><spring:message code="calendar.template.calendar.private" /></label>&nbsp;
                    <input value="4" id="cal-4" type="radio" name="type" class="cal-check"{if type==4} checked="checked"{/if}/><label for="cal-4"><spring:message code="calendar.template.calendar.public" /></label>&nbsp;
                    <input value="3" id="cal-3" type="radio" name="type" class="cal-check"{if type==3} checked="checked"{/if}/><label for="cal-3"><spring:message code="calendar.template.calendar.friend" /></label>
                </td>
            </tr>--%>
            {else}<tr>
                <th><spring:message code="calendar.template.calendar.creator" /></th>
                <td>\${creatorName}</td>
            </tr>{/if}
            </tbody>
        </table>
    </form>
</textarea>

<textarea class="jst-tpl" id="eventFormTpl">
    <form id="eventForm"><input type="hidden" name="eventId" value="\${id}"/>
        <table class="form-layout cal-form-tb" style="margin:0;">
            <tr><th><spring:message code="calendar.template.event.title" /></th><td><input type="text" class="f-text" maxlength="50" name="title" value="\${title}"/></td></tr>
            <tr><th><spring:message code="calendar.template.event.startTime"/></th><td><input type="text" class="f-text" style="width:186px;" readonly="readonly" maxlength="50" id="startTime" name="startTime" value="\${startTime|date:'Y-m-d H:i'}"/><label for="wholeDay" style="margin-left:5px;"><input type="checkbox" class="cal-check" name="wholeDay" id="wholeDay" onchange="Ccs('endTimeRow').toggle();" value="true"{if wholeDay} checked="checked"{/if}/><spring:message code="calendar.template.event.wholeDay"/></label></td></tr>
            <tr id="endTimeRow"{if wholeDay} style="display:none;"{/if}><th><spring:message code="calendar.template.event.endTime"/></th><td><input type="text" class="f-text" style="width:186px;" readonly="readonly" maxlength="50" id="endTime" name="endTime" value="\${endTime|date:'Y-m-d H:i'}"/></td></tr>
            <tr>
                <th><spring:message code="calendar.name"/></th>
                <td><select name="calendarId" class="f-text">
                    {for cal in calendars}<option value="\${cal.calendarId}"{if calendarId==cal.calendarId} selected="selected"{/if}>\${cal.name}</option>{/for}
                </select></td>
            </tr>
            <tr><th><spring:message code="calendar.template.event.description"/></th><td><input type="text" class="f-text" maxlength="50" name="description" value="\${description}"/></td></tr>
            <tr><th><spring:message code="calendar.template.event.url"/></th><td><input type="text" class="f-text" maxlength="50" name="url" value="\${url}"/></td></tr>
            <tr><th><spring:message code="calendar.template.event.location"/></th><td><input type="text" class="f-text" maxlength="50" name="location" value="\${location}"/></td></tr>
            <tr><th><spring:message code="calendar.template.event.recur"/></th><td>
                <spring:message code="calendar.template.event.peer"/><select name="interval">
                {for i in [1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30]}
                <option value="\${i}">\${i}</option>
                {/for}
            </select>
                <select name="recurType" onchange="this.nextSibling.style.display=this.value=='WEEKLY'?'':'none';">
                    <option value="NONE"><spring:message code="calendar.template.event.recur.none"/></option>
                    <option value="DAILY"><spring:message code="calendar.template.event.recur.daily"/></option>
                    <option value="WEEKLY"><spring:message code="calendar.template.event.recur.weekly"/></option>
                    <option value="MONTHLY"><spring:message code="calendar.template.event.recur.monthly"/><%--<spring:message code="calendar.the.same.day"/>--%></option>
                    <%--<option value="4"><spring:message code="calendar.on.the.same.week"/></option>--%>
                    <option value="YEARLY"><spring:message code="calendar.template.event.recur.yearly"/></option>
                </select><div style="display:none;">
                <input value="SU" id="r-recur-0" type="checkbox" name="byday" class="cal-check"/><label for="r-recur-0"><spring:message code="calendar.template.event.recur.su"/></label>&nbsp;
                <input value="MO" id="r-recur-1" type="checkbox" name="byday" class="cal-check"/><label for="r-recur-1"><spring:message code="calendar.template.event.recur.mo"/></label>&nbsp;
                <input value="TU" id="r-recur-2" type="checkbox" name="byday" class="cal-check"/><label for="r-recur-2"><spring:message code="calendar.template.event.recur.tu"/></label>&nbsp;
                <input value="WE" id="r-recur-3" type="checkbox" name="byday" class="cal-check"/><label for="r-recur-3"><spring:message code="calendar.template.event.recur.we"/></label>&nbsp;
                <input value="TH" id="r-recur-4" type="checkbox" name="byday" class="cal-check"/><label for="r-recur-4"><spring:message code="calendar.template.event.recur.th"/></label>&nbsp;
                <input value="FR" id="r-recur-5" type="checkbox" name="byday" class="cal-check"/><label for="r-recur-5"><spring:message code="calendar.template.event.recur.fr"/></label>&nbsp;
                <input value="SA" id="r-recur-6" type="checkbox" name="byday" class="cal-check"/><label for="r-recur-6"><spring:message code="calendar.template.event.recur.sa"/></label>
            </div>
            </td></tr>
            <tr><th><spring:message code="calendar.template.event.recur.endTime"/></th><td><input type="text" class="f-text" style="width:186px;" maxlength="50" id="repeatEndTime" name="repeatEndTime" value="\${repeatEndTime|date:'Y-m-d H:i'}" onkeydown="if(event.keyCode==8 ||event.keyCode==46)this.value='';return false;"/></td></tr>
            <tr><th><spring:message code="calendar.template.event.remind"/></th><td><a href="#" id="addReminder" onclick="return Ccs.app.Calendar.cal.addReminder(this);"><spring:message code="calendar.template.event.addRemind"/></a></td></tr>
        </table></form>
</textarea>

<textarea class="jst-tpl" id="eventTpl"><div class="cal-event" tid="ce\${startTime}" style="background:\${color};border-color:\${darkColor}">
    <dl>
        {if !wholeDay}<dt style="background-color:\${darkColor};">\${startTime|date:"H:i"}-\${endTime|date:"r:i"}{if lock}<i class="lock"></i>{/if}{if recurDiff>-1}<i class="recur"></i>{/if}{if remindCount}<i class="remind"></i>{/if}</dt>{/if}
        <dd>\${title|ellipsis:10}{if wholeDay}{if lock}<i class="lock"></i>{/if}{if recurDiff>-1}<i class="recur"></i>{/if}{if remindCount}<i class="remind"></i>{/if}{/if}</dd>
    </dl>
</div>
</textarea>

<textarea class="jst-tpl" id="listEventTpl"><div onmouseover="this.style.backgroundColor='#ddd';" onmouseout="this.style.backgroundColor='';" class="cal-event" style="color:\${color}" tid="ce\${startTime}">{if wholeDay}<span style="background:\${color}">　　　　　　</span>　{if Ccs.isIE}&nbsp;{/if}\${title|ellipsis:30}{else}\${startTime|date:"H:i"}-\${endTime|date:"r:i"}&nbsp;&nbsp;&nbsp;&nbsp;{/if}\${title|ellipsis:30}{if lock}<i class="lock1"></i>{/if}{if recurDiff>-1}<i class="recur1"></i>{/if}{if remindCount}<i class="remind1"></i>{/if}</div>
</textarea>

<textarea class="jst-tpl" id="tipTpl">
    <dl>
        <dt><spring:message code="calendar.template.event.title"/>：<span>\${title}</span></dt>
        <dd><spring:message code="calendar.template.event.time"/>：<span>{if !wholeDay}\${startTime|date:"<spring:message code="calendar.template.event.timeFormat"/>"}-\${endTime|date:"<spring:message code="calendar.template.event.timeFormat"/>"}{else}\${startTime|date:"<spring:message code="calendar.template.event.timeFormat1"/>"}{/if}</span></dd>
        {if description}<dd><spring:message code="calendar.template.event.description"/>：<span>\${description}</span></dd>{/if}
        {if location}<dd><spring:message code="calendar.template.event.location"/>：<span>\${location}</span></dd>{/if}
        {if url}<dd><spring:message code="calendar.template.event.url"/>：<span><a href="\${url}" target="_blank">\${url}</a></span></dd>{/if}
        {if calendar.type<4}<dd><spring:message code="calendar.template.event.owner"/>：<span><a href="${contextPath}/euser/profile.do?uid=\${calendar.creator}">\${calendar.creatorName}</a></span></dd>{/if}
        <dd><spring:message code="calendar.calName"/>：<span>\${calendar.name}</span></dd>
        {if !viewOnly}<dd class="tipBtn">
        <a href="#"onclick="return Ccs.app.Calendar.cal.delEvent(\${id});"><spring:message code="calendar.delete"/></a>&nbsp;&nbsp;
        <a href="#" onclick="return Ccs.app.Calendar.cal.editEvent({hash:\${hashCode}});"><spring:message code="calendar.edit"/></a>&nbsp;&nbsp;
    </dd>{/if}
    </dl>
</textarea>


<textarea class="jst-tpl" id="containerTpl">
    <table class="cal-table{if mode} \${mode}{/if}">
        {if !viewOnly}<caption>
        <div class="left"><a href="#" class="previous" onclick="return Ccs.app.Calendar.cal.reload({t:-1});"></a><a href="#" class="next" onclick="return Ccs.app.Calendar.cal.reload({t:1});"></a><a href="#" class="today" onclick="return Ccs.app.Calendar.cal.reload({t:0});"><spring:message code="calendar.template.today"/></a><a href="#" class="refresh" onclick="return Ccs.app.Calendar.cal.reload();"><spring:message code="calendar.template.refresh"/></a></div>
        <div class="right">
            <a href="#" onclick="return Ccs.app.Calendar.cal.reload({mode:'list'});"{if mode=='list'} class="current"{/if}><spring:message code="calendar.template.mode.list"/></a>
            <a href="#" onclick="return Ccs.app.Calendar.cal.reload({mode:'month'});"{if mode=='month'} class="current"{/if}><spring:message code="calendar.template.mode.month"/></a>
            <a href="#" onclick="return Ccs.app.Calendar.cal.reload({mode:'day'});"{if !mode || mode=='day'} class="current"{/if}><spring:message code="calendar.template.mode.day"/></a>
        </div>
    </caption>{/if}
        {if !mode || mode=='day'}
        <tr>{for day in days}<th{if !viewOnly} title="<spring:message code="calendar.template.addThisDay"/>" onclick="return Ccs.app.Calendar.cal.editEvent({time:\${day.getTime()}});"{/if}{if day_index==0} class="first{if day.getMonth()==now.getMonth() && day.getDate()==now.getDate()} today{/if}"{/if}>\${day|date:"<spring:message code="calendar.template.event.timeFormat2"/>"}</th>{/for}</tr>
        <tr>{for day in days}<td style="height:\${height-52}px;" id="dayCol-\${day.getMonth() + '-' + day.getDate()}"{if day_index==0} class="first"{/if}></td>{/for}</tr>
        {elseif mode=='list'}
        <tr><td colspan="2" class="title"><spring:message code="calendar.from"/>\${days[0]|date:"<spring:message code="calendar.template.event.timeFormat3"/>"} <spring:message code="calendar.template.to"/> \${days[days.length-1]|date:"<spring:message code="calendar.template.event.timeFormat3"/>"} <spring:message code="calendar.template.count"/>\${days.length}<spring:message code="calendar.template.mode.day"/></td></tr>
        {for day in days}<tr><th onclick="return Ccs.app.Calendar.cal.editEvent({time:\${day.getTime()}});"{if day_index%2==0} class="odd"{/if}>\${day|date:"<spring:message code="calendar.template.event.timeFormat3"/>"}</th><td{if day_index%2==0} class="odd"{/if} id="dayCol-\${day.getMonth() + '-' + day.getDate()}"></td></tr>{/for}
        {elseif mode=='month'}
        <tr><th><spring:message code="calendar.template.event.recur.week"/><spring:message code="calendar.template.event.recur.mo"/></th><th><spring:message code="calendar.template.event.recur.week"/><spring:message code="calendar.template.event.recur.tu"/></th><th><spring:message code="calendar.template.event.recur.week"/><spring:message code="calendar.template.event.recur.we"/></th><th><spring:message code="calendar.template.event.recur.week"/><spring:message code="calendar.template.event.recur.th"/></th><th><spring:message code="calendar.template.event.recur.week"/><spring:message code="calendar.template.event.recur.fr"/></th><th><spring:message code="calendar.template.event.recur.week"/><spring:message code="calendar.template.event.recur.sa"/></th><th><spring:message code="calendar.template.event.recur.week"/><spring:message code="calendar.template.event.recur.su"/></th></tr>
        {for day in days}{if day_index%7==0}<tr>{/if}<td style="height:\${(height-56)*7/days.length}px;"><div class="month-title{if day.getMonth()==now.getMonth() && day.getDate()==now.getDate()} m-today{/if}" onclick="return Ccs.app.Calendar.cal.editEvent({time:\${day.getTime()}});">{if day.getDate()==1}\${day|date:"<spring:message code="calendar.template.event.timeFormat1"/>"}{else}\${day|date:"j"}{/if}</div><div class="month-item" id="dayCol-\${day.getMonth() + '-' + day.getDate()}"></div></td>{if day_index%7==6}</tr>{/if}{/for}
        {/if}
    </table>
</textarea>

<textarea class="jst-tpl" id="importFormTpl">
    <form action="importCalendar.do" enctype="multipart/form-data" method="post" id="importForm">
        <input type="hidden" name="__bUrl" value="\${location.href.split('#')[0]}"/>
        <div class="cal-import">
            <span><spring:message code="calendar.template.import.file"/></span><input type="file" class="f-text" name="file"/>	<div><spring:message code="calendar.template.import.desc"/></div>
            <span><spring:message code="calendar.template.import.target"/></span><select name="calendarId" class="f-text">
            {for cal in this}<option value="\${cal.calendarId}">\${cal.name}</option>{/for}
        </select><div><spring:message code="calendar.template.import.targetDesc"/></div>
        </div>
    </form>
</textarea>

<textarea class="jst-tpl" id="calTpl">
    <li class="p-cal-item{if selected} p-cal-item-selected" style="background:\${color}{/if}">
        <div class="left"><input type="checkbox" name="selected" value="\${id}" class="cal-check" onclick="Ccs.app.Calendar.cal.toggleCalendar(this);"{if selected} checked="checked"{/if}/><a href="#" onclick="return Ccs.app.Calendar.cal.editCalendar(\${id});">\${name|ellipsis:11}</a></div><div class="right"><a href="#" onclick="return Ccs.app.Calendar.cal.showCalMenu(event,\${id});" class="cal-down"></a></div>
    </li>
</textarea>

<textarea class="jst-tpl" id="calMenuTpl">
    <ul>
        {if canManage}<li><a class="create" href="#" onclick="return Ccs.app.Calendar.cal.editEvent({calId:\${calendarId}});"><spring:message code="calendar.template.addOnThis"/></a></li>{/if}
        <li><a class="view" href="#" onclick="return Ccs.app.Calendar.cal.selectCalendar(\${id});"><spring:message code="calendar.template.viewThis"/></a></li>
        {if canHide}<li><a class="hide" href="#" onclick="return Ccs.app.Calendar.cal.toggleCalendar({value:\${id},name:'visible',checked:false});"><spring:message code="calendar.template.hideThis"/></a></li>{/if}
        <li><a class="edit" href="#" onclick="return Ccs.app.Calendar.cal.editCalendar(\${id});"><spring:message code="calendar.edit"/></a></li>
        {if canDelete}<li><a class="delete" href="#" onclick="return Ccs.app.Calendar.cal.delCalendar(\${id});"><spring:message code="calendar.delete"/></a></li>{/if}
    </ul>
</textarea>

<textarea class="jst-tpl" id="manageCalTpl">
    <tr onmouseover="Ccs(this).addClass('hover');" onmouseout="Ccs(this).removeClass('hover');" class="p-cal-item">
        <td style="color:\${color}" class="cal-name">\${name}</td>
        <td>\${addTime|date:'Y-m-d H:i'}</td>
        <td style="padding-left:30px;">
            <input type="checkbox" name="visible" value="\${id}" onclick="Ccs.app.Calendar.cal.toggleCalendar(this);"{if visible} checked="checked"{/if}/>
        </td>
        <td>
            <a href="exportCalendar.do?id=\${id}"><spring:message code="calendar.template.export"/></a>
            <a href="#" onclick="return Ccs.app.Calendar.cal.editCalendar(\${id});"><spring:message code="calendar.edit"/></a>
            {if canDelete}<a href="#" onclick="return Ccs.app.Calendar.cal.delCalendar(\${id});"><spring:message code="calendar.delete"/></a>{/if}
        </td>
    </tr>
</textarea>

<textarea class="jst-tpl" id="remindersTpl"><div class="cal-reminder">
    <input type="hidden" name="id" value="\${id}"/>
    <select name="method\${id}" class="f-text">
        <option value="1"{if method==1} selected="selected"{/if}><spring:message code="calendar.template.remind.message"/></option>
        <option value="2"{if method==2} selected="selected"{/if}><spring:message code="calendar.template.remind.email"/></option>
        <option value="3"{if method==3} selected="selected"{/if}><spring:message code="calendar.template.remind.sms"/></option>
    </select>
    <input type="text" name="number\${id}" value="\${number}" class="f-text" size="5" onkeyup="this.value=this.value.replace(/[^\d]/g,'')" onbeforepaste="clipboardData.setData('text',clipboardData.getData('text').replace(/[^\d]/g,''))"/>
    <select name="unit\${id}" class="f-text">
        <option value="60"{if unit==60} selected="selected"{/if}><spring:message code="calendar.template.event.recur.minute"/></option>
        <option value="3600"{if unit==3600} selected="selected"{/if}><spring:message code="calendar.template.event.recur.hour"/></option>
        <option value="86400"{if unit==86400} selected="selected"{/if}><spring:message code="calendar.template.event.recur.daily"/></option>
        <option value="604800"{if unit==604800} selected="selected"{/if}><spring:message code="calendar.template.event.recur.weekly"/></option>
    </select>&nbsp;&nbsp;<a href="#" onclick="Ccs.removeNode(this.parentNode);return false;"><spring:message code="calendar.template.remove"/></a></div>
</textarea>
