/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.egov.generic.impl;

import com.gtis.common.util.UUIDGenerator;
import com.gtis.egov.calendar.utils.StringUtils;
import com.gtis.egov.generic.Message;
import com.gtis.egov.generic.MessageService;
import com.gtis.plat.service.SysMessageService;
import com.gtis.plat.vo.PfMessageSendVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageServiceImpl
implements MessageService {
    private static final Logger logger = LoggerFactory.getLogger(MessageServiceImpl.class);
    private SysMessageService sysMessageService;

    public void setSysMessageService(SysMessageService sysMessageService) {
        this.sysMessageService = sysMessageService;
    }

    public boolean sendMessage(Message message) {
        PfMessageSendVo vo = new PfMessageSendVo();
        vo.setUserId(message.getSender());
        vo.setMessageAcceptUser(StringUtils.join((Object[])message.getReceivers(), (String)","));
        vo.setMessageSendTitle(message.getSubject());
        vo.setMessageSendContent(message.getContent());
        vo.setMessageSendId(UUIDGenerator.generate());
        this.sysMessageService.insertMessage(vo);
        logger.debug("test send message [{}]", (Object)message);
        return true;
    }

    public boolean sendMail(Message message) {
        logger.debug("test send mail [{}]", (Object)message);
        return true;
    }

    public boolean sendSms(Message message) {
        logger.debug("test send sms [{}]", (Object)message);
        return true;
    }
}

