/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.egov.generic;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SystemConfig
implements InitializingBean {
    private static Logger log = LoggerFactory.getLogger(SystemConfig.class);
    private String[] necessaryConfigs;
    private static Map systemProperties;

    public void setConfiguration(Map properties) {
        systemProperties = properties;
    }

    public static String getProperty(String key) {
        return (String)systemProperties.get(key);
    }

    public static int getIntProperty(String key) {
        return SystemConfig.getIntProperty((String)key, (int)0);
    }

    public static int getIntProperty(String key, int defaultValue) {
        String property = SystemConfig.getProperty((String)key);
        int value = defaultValue;
        try {
            value = Integer.parseInt(property);
        }
        catch (NumberFormatException e) {
            log.warn(e.toString());
        }
        return value;
    }

    public static Integer getIntegerProperty(String key) {
        return SystemConfig.getIntegerProperty((String)key, null);
    }

    public static Integer getIntegerProperty(String key, Integer defaultValue) {
        String stringValue = SystemConfig.getProperty((String)key);
        Integer value = defaultValue;
        try {
            value = Integer.valueOf(stringValue);
        }
        catch (NumberFormatException e) {
            log.warn(e.toString());
        }
        return value;
    }

    public static boolean getBooleanProperty(String key) {
        return SystemConfig.getBooleanProperty((String)key, (boolean)false);
    }

    public static boolean getBooleanProperty(String key, boolean defaultValue) {
        String value = SystemConfig.getProperty((String)key);
        if (null != value) {
            return "true".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value);
        }
        return defaultValue;
    }

    public static Map getProperties() {
        return systemProperties;
    }

    public void afterPropertiesSet() throws Exception {
        String[] keys = this.necessaryConfigs;
        if (keys == null) {
            return;
        }
        int n = keys.length;
        for (int i = 0; i < n; ++i) {
            String key = StringUtils.trimToEmpty((String)keys[i]);
            if (systemProperties.containsKey(key)) continue;
            throw new IllegalStateException("Can not find property \"" + key + "\" in configuration file.");
        }
    }

    public void setNecessaryConfigs(String[] necessaryConfigs) {
        this.necessaryConfigs = necessaryConfigs;
    }
}

