/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.egov.calendar.web;

import com.gtis.egov.calendar.model.Event;
import com.gtis.egov.calendar.model.PersonalCalendar;
import com.gtis.egov.calendar.model.Reminder;
import com.gtis.egov.calendar.service.CalendarExchangeManager;
import com.gtis.egov.calendar.service.CalendarManager;
import com.gtis.egov.calendar.service.EventManager;
import com.gtis.egov.calendar.service.ReminderManager;
import com.gtis.egov.calendar.utils.DateUtils;
import com.gtis.egov.generic.SystemConfig;
import com.gtis.egov.generic.User;
import com.gtis.plat.service.SysUserService;
import com.gtis.plat.vo.PfOrganVo;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.SyndFeedOutput;
import com.wiscom.generic.base.util.FileWebInput;
import com.wiscom.generic.base.util.JsonUtils;
import com.wiscom.generic.base.util.WebInput;
import com.wiscom.generic.base.util.WebOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

/*
 * Exception performing whole class analysis ignored.
 */
public class CalendarController {
    public static final String moduleName = "calendar";
    public static final String DATE_PATTERN = "yyyy-MM-dd HH:mm";
    private static final SimpleDateFormat tsdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    public static final String DAY_PATTERN = "yyyy-MM-dd";
    public static final String MODE_DAY = "day";
    public static final String MODE_MONTH = "month";
    public static final String MODE_LIST = "list";
    private static final String IS_MANAGER = "is_calendar_manager";
    private static final String USER_ID = "___userId___";
    private static final String GROUP_ID = "___groupId___";
    private static final Logger logger = LoggerFactory.getLogger(CalendarController.class);
    public boolean isInit = false;
    public boolean isSingleMethod = false;
    private CalendarManager calendarManager;
    private EventManager eventManager;
    private ReminderManager reminderManager;
    private SysUserService sysUserService;

    public void initObject(CalendarManager calendarManager, EventManager eventManager, ReminderManager reminderManager, SysUserService sysUserService) {
        this.calendarManager = calendarManager;
        this.eventManager = eventManager;
        this.reminderManager = reminderManager;
        this.sysUserService = sysUserService;
    }

    public ModelAndView standardAdmin(HttpSession session) {
        if (session.getAttribute("is_calendar_manager") == null) {
            session.setAttribute("is_calendar_manager", (Object)Boolean.TRUE);
        }
        return new ModelAndView("redirect:admin.do");
    }

    public ModelAndView groupAdmin(User loginUser, WebInput in, HttpSession session) {
        String groupId;
        if (session.getAttribute("is_calendar_manager") == null) {
            session.setAttribute("is_calendar_manager", (Object)Boolean.TRUE);
        }
        if (StringUtils.isNotBlank((String)(groupId = in.getString("groupId")))) {
            this.initGroupCalendar(this.sysUserService.getOrganVo(groupId), loginUser.getId());
            return new ModelAndView("redirect:group.do?___groupId___=" + groupId);
        }
        HashMap<String, List> params = new HashMap<String, List>();
        params.put("groups", this.sysUserService.getAllOrganList());
        return new ModelAndView("groupAdmin", params);
    }

    public ModelAndView initGroupCalendars(User loginUser) {
        int count = 0;
        List groups = this.sysUserService.getAllOrganList();
        for (int i = 0; i < groups.size(); ++i) {
            PfOrganVo group = (PfOrganVo)groups.get(i);
            if (!this.initGroupCalendar(group, loginUser.getId())) continue;
            ++count;
        }
        return new ModelAndView("redirect:groupAdmin.do" + (count == 0 ? "" : "?count=" + count));
    }

    private boolean initGroupCalendar(PfOrganVo group, String userId) {
        List calendars = this.calendarManager.getGroupCalendars(group.getOrganId());
        if (calendars.isEmpty()) {
            com.gtis.egov.calendar.model.Calendar calendar = new com.gtis.egov.calendar.model.Calendar();
            calendar.setCreator(userId);
            calendar.setCreateTime(new Date());
            calendar.setName(group.getOrganName());
            calendar.setType((short)6);
            calendar.setOwner(group.getOrganId());
            this.calendarManager.saveCalendar(calendar);
            return true;
        }
        return false;
    }

    public ModelAndView personalView(WebInput in, HttpSession session) {
        if (session.getAttribute("is_calendar_manager") == null) {
            session.setAttribute("is_calendar_manager", (Object)Boolean.TRUE);
        }
        String groupId = in.getString("groupId");
        String userId = in.getString("userId");
        if (StringUtils.isNotBlank((String)userId)) {
            return new ModelAndView("redirect:index.do?___userId___=" + userId);
        }
        HashMap<String, List> params = new HashMap<String, List>();
        params.put("groups", this.sysUserService.getAllOrganList());
        if (StringUtils.isNotBlank((String)groupId)) {
            params.put("users", this.sysUserService.getUserListByOragn(groupId));
        }
        return new ModelAndView("personalView", params);
    }

    public ModelAndView index(User loginUser, WebInput in, WebOutput webout) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String userId = in.getString("___userId___");
        if (StringUtils.isBlank((String)userId)) {
            userId = loginUser.getId();
        }
        List personalCalendars = this.calendarManager.getPersonalCalendars(userId, Boolean.TRUE);
        boolean jsonMethod = in.getBoolean("__json", false);
        if (jsonMethod) {
            this.outputEvents(userId, personalCalendars, in, webout, true);
            return null;
        }
        boolean isGetCalMethod = in.getBoolean("__cal", false);
        if (isGetCalMethod) {
            try {
                webout.toJson((Object)personalCalendars);
            }
            catch (IOException e) {
                // empty catch block
            }
            return null;
        }
        params.put("calendars", JsonUtils.toString((Object)personalCalendars));
        params.put("personalCalendars", personalCalendars);
        params.put("isManager", this.isManager(in));
        params.put("viewOnly", StringUtils.isBlank((String)userId));
        return new ModelAndView("index", params);
    }

    public ModelAndView rss(User loginUser, WebInput in, WebOutput webout) {
        List personalCalendars = this.calendarManager.getPersonalCalendars(loginUser.getId(), Boolean.TRUE);
        Date start = new Date();
        Date end = DateUtils.addDays((Date)start, (int)in.getInt("day", 7));
        Long[] ids = new Long[personalCalendars.size()];
        for (int i = 0; i < personalCalendars.size(); ++i) {
            PersonalCalendar personalCalendar = (PersonalCalendar)personalCalendars.get(i);
            if (!personalCalendar.isSelected() || !personalCalendar.isVisible()) continue;
            ids[i] = personalCalendar.getCalendarId();
        }
        List events = this.eventManager.getEvents(loginUser.getId(), ids, start, end);
        Collections.sort(events);
        SyndFeed feed = this.buildFeed(events, loginUser.getId());
        webout.setContentType("text/xml", "utf-8");
        SyndFeedOutput output = new SyndFeedOutput();
        try {
            output.output(feed, (Writer)webout.getResponse().getWriter());
        }
        catch (Exception e) {
            logger.error("Could not write the rss", (Throwable)e);
        }
        return null;
    }

    private SyndFeed buildFeed(List events, String userId) {
        SyndFeedImpl feed = new SyndFeedImpl();
        feed.setFeedType("rss_2.0");
        feed.setAuthor(userId);
        feed.setTitle(SystemConfig.getProperty((String)"calendar.feed.name"));
        feed.setDescription("");
        feed.setLink(SystemConfig.getProperty((String)"calendar.url"));
        ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
        for (int i = 0; i < events.size(); ++i) {
            Event event = (Event)events.get(i);
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setLink(SystemConfig.getProperty((String)"calendar.url"));
            entry.setTitle(event.getTitle());
            SyndContentImpl description = new SyndContentImpl();
            description.setType("text/html");
            description.setValue(this.getContent(event));
            entry.setDescription((SyndContent)description);
            entry.setPublishedDate(event.getStartTime());
            entries.add(entry);
        }
        feed.setEntries(entries);
        return feed;
    }

    private String getContent(Event event) {
        return MessageFormat.format(SystemConfig.getProperty((String)"calendar.remind.content.rss"), event.isWholeDay() ? tsdf.format(event.getStartTime()) : tsdf.format(event.getStartTime()) + " to " + tsdf.format(event.getEndTime()), StringUtils.trimToEmpty((String)event.getDescription()), StringUtils.trimToEmpty((String)event.getLocation()), StringUtils.trimToEmpty((String)event.getUrl()), event.getColor());
    }

    public ModelAndView group(User loginUser, WebInput in, WebOutput webout) {
        boolean jsonMethod;
        if (!this.isManager(in)) {
            return new ModelAndView("redirect:index.do");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        String groupId = in.getString("___groupId___");
        List calendars = this.calendarManager.getGroupCalendars(groupId);
        if (calendars == null || calendars.size() == 0) {
            throw new RuntimeException("group not found");
        }
        List groupCalendars = this.calendarManager.getGroupPersonalCalendars(loginUser.getId(), groupId);
        boolean changed = false;
        for (int i = 0; i < calendars.size(); ++i) {
            com.gtis.egov.calendar.model.Calendar calendar = (com.gtis.egov.calendar.model.Calendar)calendars.get(i);
            boolean found = false;
            for (int j = 0; j < groupCalendars.size(); ++j) {
                PersonalCalendar pCal = (PersonalCalendar)groupCalendars.get(j);
                if (!pCal.getCalendarId().equals(calendar.getId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            PersonalCalendar personalCalendar = new PersonalCalendar();
            personalCalendar.setCalendarId(calendar.getId());
            personalCalendar.setName(calendar.getName());
            personalCalendar.setCreator(loginUser.getId());
            personalCalendar.setAddTime(new Date());
            personalCalendar.setColor(calendar.getColor());
            this.calendarManager.savePersonalCalendar(personalCalendar);
            changed = true;
        }
        if (changed) {
            groupCalendars = this.calendarManager.getGroupPersonalCalendars(loginUser.getId(), groupId);
        }
        if (jsonMethod = in.getBoolean("__json", false)) {
            this.outputEvents(loginUser.getId(), groupCalendars, in, webout, true);
            return null;
        }
        boolean isGetCalMethod = in.getBoolean("__cal", false);
        if (isGetCalMethod) {
            try {
                webout.toJson((Object)groupCalendars);
            }
            catch (IOException e) {
                // empty catch block
            }
            return null;
        }
        params.put("calendars", JsonUtils.toString((Object)groupCalendars));
        params.put("groupCalendars", groupCalendars);
        params.put("isManager", this.isManager(in));
        return new ModelAndView("group", params);
    }

    public ModelAndView admin(User loginUser, WebInput in, WebOutput webout) {
        if (!this.isManager(in)) {
            return new ModelAndView("redirect:index.do");
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        List standardCalendars = this.calendarManager.getStandardPersonalCalendars(loginUser.getId());
        boolean jsonMethod = in.getBoolean("__json", false);
        if (jsonMethod) {
            this.outputEvents(loginUser.getId(), standardCalendars, in, webout, true);
            return null;
        }
        boolean isGetCalMethod = in.getBoolean("__cal", false);
        if (isGetCalMethod) {
            try {
                webout.toJson((Object)standardCalendars);
            }
            catch (IOException e) {
                // empty catch block
            }
            return null;
        }
        params.put("calendars", JsonUtils.toString((Object)standardCalendars));
        params.put("standardCalendars", standardCalendars);
        params.put("isManager", this.isManager(in));
        return new ModelAndView("admin", params);
    }

    public ModelAndView manage(User loginUser, WebInput in, WebOutput webout) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        List personalCalendars = this.calendarManager.getPersonalCalendars(loginUser.getId(), null);
        boolean isGetCalMethod = in.getBoolean("__cal", false);
        if (isGetCalMethod) {
            try {
                webout.toJson((Object)personalCalendars);
            }
            catch (IOException e) {
                // empty catch block
            }
            return null;
        }
        params.put("calendars", JsonUtils.toString((Object)personalCalendars));
        params.put("personalCalendars", personalCalendars);
        params.put("isManager", this.isManager(in));
        return new ModelAndView("manage", params);
    }

    public ModelAndView add(User loginUser, WebInput in) {
        String msg;
        Long calendarId = in.getLong("id");
        String backUrl = CalendarController.getBackUrl((WebInput)in).replaceAll("&msg=\\w+", "");
        backUrl = backUrl + (backUrl.indexOf("?") > -1 ? "&" : "?");
        PersonalCalendar personalCalendar = this.calendarManager.getPersonalCalendar(calendarId, loginUser.getId());
        if (personalCalendar == null) {
            com.gtis.egov.calendar.model.Calendar calendar = this.calendarManager.getCalendar(calendarId);
            personalCalendar = new PersonalCalendar();
            personalCalendar.setCalendarId(calendar.getId());
            personalCalendar.setName(calendar.getName());
            personalCalendar.setCreator(loginUser.getId());
            personalCalendar.setAddTime(new Date());
            personalCalendar.setColor(calendar.getColor());
            this.calendarManager.savePersonalCalendar(personalCalendar);
            msg = "msg=success";
        } else {
            msg = "msg=exist";
        }
        return new ModelAndView(backUrl + msg);
    }

    public ModelAndView editCalendar(User loginUser, WebInput in, WebOutput webout) {
        PersonalCalendar personalCalendar;
        Long calendarId = in.getLong("calendarId");
        String owner = in.getString("owner");
        String name = in.getString("name");
        String description = in.getString("description");
        String color = in.getString("color");
        short type = (short)in.getInt("type", 0);
        Date now = new Date();
        String userId = loginUser.getId();
        if (StringUtils.isBlank((String)name) || StringUtils.isBlank((String)color)) {
            return null;
        }
        if (calendarId == null) {
            com.gtis.egov.calendar.model.Calendar calendar = new com.gtis.egov.calendar.model.Calendar();
            calendar.setCreator(userId);
            calendar.setCreateTime(now);
            calendar.setName(name);
            calendar.setDescription(description);
            calendar.setColor(color);
            calendar.setType(type);
            if (owner != null) {
                calendar.setOwner(owner);
            }
            this.calendarManager.saveCalendar(calendar);
            personalCalendar = new PersonalCalendar();
            personalCalendar.setCreator(userId);
            personalCalendar.setAddTime(now);
            personalCalendar.setCalendarId(calendar.getId());
        } else {
            personalCalendar = this.calendarManager.getPersonalCalendar(calendarId);
            com.gtis.egov.calendar.model.Calendar calendar = this.calendarManager.getCalendar(personalCalendar.getCalendarId());
            if (personalCalendar.getCalendarCreator().equals(loginUser.getId()) || this.isManager(in) || this.hasManagePermission(calendar, loginUser.getId())) {
                calendar.setName(name);
                calendar.setDescription(description);
                calendar.setColor(color);
                calendar.setType(type);
                if (owner != null) {
                    calendar.setOwner(owner);
                }
                this.calendarManager.saveCalendar(calendar);
            }
        }
        if (personalCalendar.getCreator().equals(loginUser.getId())) {
            personalCalendar.setName(name);
            personalCalendar.setColor(color);
            this.calendarManager.savePersonalCalendar(personalCalendar);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("status", "1");
        try {
            webout.toJson(params);
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    public ModelAndView editEvent(User loginUser, WebInput in, WebOutput webout) {
        Long calendarId = in.getLong("calendarId");
        Date startTime = in.getDate("startTime", "yyyy-MM-dd HH:mm", null);
        Date endTime = in.getDate("endTime", "yyyy-MM-dd HH:mm", null);
        Date repeatEndTime = in.getDate("repeatEndTime", "yyyy-MM-dd HH:mm", null);
        Long eventId = in.getLong("eventId");
        String recurrenceRule = CalendarController.getRecurrenceRule((WebInput)in);
        String title = in.getString("title");
        if (calendarId == null || StringUtils.isBlank((String)title) || startTime == null && StringUtils.isBlank((String)recurrenceRule)) {
            return null;
        }
        Event event = eventId == null ? new Event() : this.eventManager.getEvent(eventId);
        com.gtis.egov.calendar.model.Calendar calendar = this.calendarManager.getCalendar(calendarId);
        if (eventId == null || event.getCreator().equals(loginUser.getId()) || this.isManager(in) || this.hasManagePermission(calendar, loginUser.getId())) {
            event.setCalendarId(calendarId);
            event.setTitle(in.getString("title"));
            event.setUrl(in.getString("url"));
            event.setLocation(in.getString("location"));
            event.setDescription(in.getString("description"));
            event.setStartTime(startTime);
            event.setEndTime(endTime);
            event.setUpdateTime(new Date());
            event.setWholeDay(in.getBoolean("wholeDay"));
            event.setCreator(loginUser.getId());
            if (recurrenceRule != null) {
                event.setRecurrenceRule(recurrenceRule);
                event.setRepeatEndTime(repeatEndTime);
            }
            this.eventManager.saveEvent(event);
            this.saveReminders(loginUser, event.getId(), in);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("status", "1");
            try {
                webout.toJson(params);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    public void saveReminders(User loginUser, Long eventId, WebInput in) {
        int number;
        int unit;
        short method;
        int i;
        String[] ids = in.getStrings("id");
        List reminders = this.reminderManager.getReminders(eventId);
        for (i = 0; i < reminders.size(); ++i) {
            Reminder reminder = (Reminder)reminders.get(i);
            Long id = reminder.getId();
            if (CalendarController.isIdExist((Long)id, (String[])ids)) {
                method = (short)in.getInt("method" + id, 0);
                unit = in.getInt("unit" + id, 0);
                number = in.getInt("number" + id, 0);
                reminder.setMethod(method);
                reminder.setSeconds(unit * number);
                this.reminderManager.saveReminder(reminder);
                continue;
            }
            this.reminderManager.removeReminder(id);
        }
        if (ids != null) {
            for (i = 0; i < ids.length; ++i) {
                String id = ids[i];
                try {
                    Long.valueOf(id);
                    continue;
                }
                catch (NumberFormatException e) {
                    method = (short)in.getInt("method" + id, 0);
                    unit = in.getInt("unit" + id, 0);
                    number = in.getInt("number" + id, 0);
                    Reminder reminder = new Reminder();
                    reminder.setMethod(method);
                    reminder.setCreator(loginUser.getId());
                    reminder.setEventId(eventId);
                    reminder.setSeconds(unit * number);
                    if (reminders.indexOf(reminder) != -1) continue;
                    reminders.add(reminder);
                    this.reminderManager.saveReminder(reminder);
                }
            }
        }
    }

    private static boolean isIdExist(Long id, String[] ids) {
        if (ids != null) {
            for (int i = 0; i < ids.length; ++i) {
                if (!ids[i].equals(String.valueOf(id))) continue;
                return true;
            }
        }
        return false;
    }

    public ModelAndView delEvent(User loginUser, WebInput in, WebOutput webout) {
        Long eventId = in.getLong("id");
        Event event = this.eventManager.getEvent(eventId);
        if (event.getCreator().equals(loginUser.getId())) {
            this.eventManager.removeEvent(eventId);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("status", "1");
        try {
            webout.toJson(params);
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    public ModelAndView delCal(User loginUser, WebInput in, WebOutput webout) {
        HashMap<String, String> params = new HashMap<String, String>();
        Long calendarId = in.getLong("id");
        PersonalCalendar personalCalendar = this.calendarManager.getPersonalCalendar(calendarId);
        com.gtis.egov.calendar.model.Calendar calendar = this.calendarManager.getCalendar(personalCalendar.getCalendarId());
        if (personalCalendar.getCalendarCreator().equals(loginUser.getId()) || this.isManager(in) || this.hasManagePermission(calendar, loginUser.getId())) {
            if (logger.isDebugEnabled()) {
                logger.debug("remove calendar success,personalCalendar is ({}) ", (Object)personalCalendar);
            }
            this.calendarManager.removeCalendar(personalCalendar.getCalendarId());
        }
        if (personalCalendar.getCreator().equals(loginUser.getId())) {
            this.calendarManager.removePersonalCalendar(calendarId);
        }
        params.put("status", "1");
        try {
            webout.toJson(params);
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    public ModelAndView toggleCalendar(User loginUser, WebInput in, WebOutput webout) {
        HashMap<String, String> params = new HashMap<String, String>();
        Long id = in.getLong("id");
        String type = in.getString("type");
        boolean checked = in.getBoolean("checked");
        if ("selected".equals(type)) {
            this.calendarManager.changePersonalCalendarSelectedStatus(loginUser.getId(), new Long[]{id}, checked);
        } else if ("visible".equals(type)) {
            this.calendarManager.changePersonalCalendarVisibleStatus(loginUser.getId(), new Long[]{id}, checked);
        }
        params.put("status", "1");
        try {
            webout.toJson(params);
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    public ModelAndView selectCalendar(User loginUser, WebInput in, WebOutput webout) {
        HashMap<String, String> params = new HashMap<String, String>();
        Long calendarId = in.getLong("id");
        Long[] oIds = in.getLongObjects("oId");
        this.calendarManager.changePersonalCalendarSelectedStatus(loginUser.getId(), new Long[]{calendarId}, true);
        this.calendarManager.changePersonalCalendarSelectedStatus(loginUser.getId(), oIds, false);
        params.put("status", "1");
        try {
            webout.toJson(params);
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView importCalendar(User loginUser, WebInput in, FileWebInput fin, CalendarExchangeManager calendarExchangeManager) {
        String backUrl = CalendarController.getBackUrl((WebInput)in).replaceAll("[?&]count=\\w+", "");
        String msg = "";
        MultipartFile mfile = fin.getMultipartFile("file");
        Long calendarId = in.getLong("calendarId");
        com.gtis.egov.calendar.model.Calendar calendar = this.calendarManager.getCalendar(calendarId);
        if ((calendar.getCreator().equals(loginUser.getId()) || this.isManager(in) || this.hasManagePermission(calendar, loginUser.getId())) && mfile.getSize() > 0L) {
            InputStream is = null;
            try {
                is = mfile.getInputStream();
                int count = calendarExchangeManager.importIcsCalendarEvents(is, calendarId);
                msg = (backUrl.indexOf("?") > -1 ? "&" : "?") + "count=" + count;
            }
            catch (IOException e) {
                logger.error("import calendar {} failed!", (Object)mfile.getOriginalFilename());
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return new ModelAndView(backUrl + msg);
    }

    public ModelAndView exportCalendar(WebInput in, WebOutput webout, CalendarExchangeManager calendarExchangeManager) throws Exception {
        Long id = in.getLong("id");
        PersonalCalendar personalCalendar = this.calendarManager.getPersonalCalendar(id);
        String fname = personalCalendar.getName() + ".ics";
        HttpServletResponse res = webout.getResponse();
        webout.setContentType("text/calendar", "UTF-8");
        res.setHeader("Content-Disposition", "attachment; filename=\"" + new String(fname.getBytes("gb2312"), "iso8859-1") + "\"");
        try {
            calendarExchangeManager.exportIcsCalendarEvents((OutputStream)res.getOutputStream(), personalCalendar.getCalendarId());
        }
        catch (IOException e) {
            logger.error("export calendar {} failed!", (Object)fname);
        }
        return null;
    }

    public ModelAndView reminders(WebInput in, WebOutput webout) {
        Long eventId = in.getLong("eventId");
        try {
            webout.toJson((Object)this.reminderManager.getReminders(eventId));
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    private void outputEvents(String userId, List personalCalendars, WebInput in, WebOutput webout, boolean selectedOnly) {
        Date start = in.getDate("__s", "yyyy-MM-dd", null);
        Date end = in.getDate("__e", "yyyy-MM-dd", null);
        if (start == null || end == null || personalCalendars == null || personalCalendars.size() == 0) {
            return;
        }
        Long[] ids = new Long[personalCalendars.size()];
        for (int i = 0; i < personalCalendars.size(); ++i) {
            PersonalCalendar personalCalendar = (PersonalCalendar)personalCalendars.get(i);
            if (selectedOnly && (!personalCalendar.isSelected() || !personalCalendar.isVisible())) continue;
            ids[i] = personalCalendar.getCalendarId();
        }
        try {
            webout.toJson((Object)this.eventManager.getEvents(userId, ids, start, end));
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private boolean hasManagePermission(com.gtis.egov.calendar.model.Calendar calendar, String userId) {
        return false;
    }

    private boolean isManager(WebInput in) {
        Boolean isManager = (Boolean)in.getRequest().getSession().getAttribute("is_calendar_manager");
        return isManager != null && isManager != false;
    }

    private static String getRecurrenceRule(WebInput in) {
        String interval = in.getString("interval");
        String recurType = in.getString("recurType");
        if (StringUtils.isNotBlank((String)recurType)) {
            StringBuffer sb = new StringBuffer();
            if (!"NONE".equals(recurType)) {
                sb.append("FREQ=").append(recurType).append(";WKST=SU;INTERVAL=").append(interval);
                if ("MONTHLY".equals(recurType)) {
                    Date startTime = in.getDate("startTime", "yyyy-MM-dd HH:mm", null);
                    Calendar cl = Calendar.getInstance();
                    cl.setTime(startTime);
                    sb.append(";BYDAY=SU,MO,TU,WE,TH,FR,SA;BYSETPOS=").append(cl.get(5));
                } else if ("WEEKLY".equals(recurType)) {
                    Object[] byday = in.getStrings("byday");
                    if (byday == null) {
                        return null;
                    }
                    sb.append(";BYDAY=").append(StringUtils.join((Object[])byday, (String)","));
                }
            }
            return sb.toString();
        }
        return null;
    }

    private static String getBackUrl(WebInput in) {
        return "redirect:" + in.getString("__bUrl");
    }
}

