/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.egov.calendar.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class DateUtils
extends org.apache.commons.lang.time.DateUtils {
    public static final String defaultPattern = "yyyy-MM-dd HH:mm:ss";
    public static final String defaultPatternWithZone = "yyyy-MM-dd HH:mm:ss z";
    public static final String shortPattern = "yyyy-MM-dd";
    public static final String TIME_PATTERN = "yyyy-MM-dd HH:mm";

    public static Date strToDateLong(String strDate) {
        return DateUtils.parse((String)strDate, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static String dateToStr(Date date) {
        return DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd");
    }

    public static Date parseShortDate(String strDate) {
        return DateUtils.parse((String)strDate, (String)"yyyy-MM-dd");
    }

    public static Date parse(String dateString, String pattern) {
        if (StringUtils.isBlank((String)dateString)) {
            return null;
        }
        String pat = pattern;
        if (StringUtils.isBlank((String)pat)) {
            pat = "yyyy-MM-dd HH:mm:ss";
        }
        try {
            return new SimpleDateFormat(pat).parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String formatDate(Date date, String pattern) {
        if (StringUtils.isBlank((String)pattern)) {
            pattern = "yyyy-MM-dd HH:mm:ss";
        }
        return new SimpleDateFormat(pattern).format(date);
    }

    public static String formatDate(Date date, String pattern, String timeZone) {
        if (StringUtils.isBlank((String)pattern)) {
            pattern = "yyyy-MM-dd HH:mm:ss z";
        }
        if (StringUtils.isBlank((String)timeZone)) {
            timeZone = "GMT";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        sdf.setTimeZone(TimeZone.getTimeZone(timeZone));
        return sdf.format(date);
    }

    public static String formatDate(Date date) {
        return DateUtils.formatDate((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static String formatResentDate(Date date) {
        long dif = Math.abs(date.getTime() - System.currentTimeMillis());
        String ret = dif > 86400000L ? DateUtils.formatDate((Date)date) : (dif > 3600000L ? String.valueOf(dif / 3600000L) + "\u5c0f\u65f6\u524d" : (dif > 60000L ? String.valueOf(dif / 60000L) + "\u5206\u949f\u524d" : String.valueOf((int)(dif / 1000L)) + "\u79d2\u524d"));
        return ret;
    }

    public static String getDifferenceDate(Date now, Date endDate) {
        String ret;
        long dif = endDate.getTime() - now.getTime();
        long times = 86400000L;
        if (dif <= 0L) {
            return "-1";
        }
        if (dif > times) {
            long days = dif / times;
            ret = dif % times != 0L ? "\u4e0d\u5230" + ++days + "\u5929" : days + "\u5929";
        } else {
            ret = dif > 3600000L ? String.valueOf(dif / 3600000L) + "\u5c0f\u65f6" : (dif > 60000L ? String.valueOf(dif / 60000L) + "\u5206\u949f" : String.valueOf((int)(dif / 1000L)) + "\u79d2");
        }
        return ret;
    }

    public static String getDaysBetweenTwoDates(Date nowDate, Date endDate) {
        return DateUtils.getDaysBetweenTwoDates((String)DateUtils.formatDate((Date)nowDate), (String)DateUtils.formatDate((Date)endDate));
    }

    public static String getDaysBetweenTwoDates(String nowDate, String endDate) {
        Date dtFrom = DateUtils.parse((String)nowDate, (String)"yyyy-MM-dd");
        Date dtEnd = DateUtils.parse((String)endDate, (String)"yyyy-MM-dd");
        long begin = dtFrom.getTime();
        long end = dtEnd.getTime();
        long inter = end - begin;
        if (inter < 0L) {
            inter *= -1L;
        }
        long dateMillSec = 86400000L;
        long dateCnt = inter / dateMillSec;
        long remainder = inter % dateMillSec;
        if (remainder != 0L) {
            ++dateCnt;
        }
        return String.valueOf(dateCnt);
    }

    public static Date getEndOfDay(Date day) {
        return DateUtils.getEndOfDay((Date)day, (Calendar)Calendar.getInstance());
    }

    public static Date getEndOfDay(Date day, Calendar cal) {
        if (day == null) {
            day = new Date();
        }
        cal.setTime(day);
        cal.set(11, cal.getMaximum(11));
        cal.set(12, cal.getMaximum(12));
        cal.set(13, cal.getMaximum(13));
        cal.set(14, cal.getMaximum(14));
        return cal.getTime();
    }

    public static Date getEndOfMonth(Date day) {
        return DateUtils.getEndOfMonth((Date)day, (Calendar)Calendar.getInstance());
    }

    public static Date getStartOfMonth(Date day) {
        return DateUtils.getStartOfMonth((Date)day, (Calendar)Calendar.getInstance());
    }

    private static Date getStartOfMonth(Date day, Calendar cal) {
        if (day == null) {
            day = new Date();
        }
        cal.setTime(day);
        cal.set(11, cal.getMinimum(11));
        cal.set(12, cal.getMinimum(12));
        cal.set(13, cal.getMinimum(13));
        cal.set(14, cal.getMinimum(14));
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date getEndOfMonth(Date day, Calendar cal) {
        if (day == null) {
            day = new Date();
        }
        cal.setTime(day);
        cal.set(11, cal.getMaximum(11));
        cal.set(12, cal.getMaximum(12));
        cal.set(13, cal.getMaximum(13));
        cal.set(14, cal.getMaximum(14));
        cal.set(5, 1);
        cal.add(2, 1);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static Date getStartOfDay(Date day) {
        return DateUtils.getStartOfDay((Date)day, (Calendar)Calendar.getInstance());
    }

    public static Date getStartOfDay(Date day, Calendar cal) {
        if (day == null) {
            day = new Date();
        }
        cal.setTime(day);
        cal.set(11, cal.getMinimum(11));
        cal.set(12, cal.getMinimum(12));
        cal.set(13, cal.getMinimum(13));
        cal.set(14, cal.getMinimum(14));
        return cal.getTime();
    }

    public static Date getNoonOfDay(Date day, Calendar cal) {
        if (day == null) {
            day = new Date();
        }
        cal.setTime(day);
        cal.set(11, 12);
        cal.set(12, cal.getMinimum(12));
        cal.set(13, cal.getMinimum(13));
        cal.set(14, cal.getMinimum(14));
        return cal.getTime();
    }
}

