/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.egov.calendar.service.impl;

import com.gtis.egov.calendar.Helper;
import com.gtis.egov.calendar.dao.ReminderDAO;
import com.gtis.egov.calendar.model.Event;
import com.gtis.egov.calendar.model.PersonalCalendar;
import com.gtis.egov.calendar.model.Reminder;
import com.gtis.egov.calendar.service.CalendarManager;
import com.gtis.egov.calendar.service.EventManager;
import com.gtis.egov.calendar.service.ReminderManager;
import com.gtis.egov.calendar.utils.DateUtils;
import com.gtis.egov.calendar.utils.StringUtils;
import com.gtis.egov.generic.Message;
import com.gtis.egov.generic.MessageService;
import com.gtis.egov.generic.SystemConfig;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReminderManagerImpl
implements ReminderManager {
    private static final Logger logger = LoggerFactory.getLogger(ReminderManagerImpl.class);
    private CalendarManager calendarManager;
    private EventManager eventManager;
    private ReminderDAO reminderDAO;
    private MessageService messageService;
    private Set remindersQueue = new TreeSet();
    private static final SimpleDateFormat tsdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private int remindInterval;

    public void setCalendarManager(CalendarManager calendarManager) {
        this.calendarManager = calendarManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setReminderDAO(ReminderDAO reminderDAO) {
        this.reminderDAO = reminderDAO;
    }

    public void setMessageService(MessageService messageService) {
        this.messageService = messageService;
    }

    public void setRemindInterval(int remindInterval) {
        this.remindInterval = remindInterval;
    }

    public Reminder saveReminder(Reminder reminder) {
        Date end;
        Date now;
        this.reminderDAO.saveReminder(reminder);
        Event event = reminder.getEvent();
        if (event == null) {
            event = this.eventManager.getEvent(reminder.getEventId());
            reminder.setEvent(event);
        }
        if (event.getColor() == null) {
            event.setColor(this.calendarManager.getCalendar(event.getCalendarId()).getColor());
        }
        if ((reminder = this.parseReminder(reminder, now = new Date(), end = DateUtils.addSeconds((Date)now, (int)this.remindInterval))) != null && reminder.getRemindDate().after(now) && reminder.getRemindDate().before(end)) {
            this.remindersQueue.add(reminder);
        }
        return reminder;
    }

    public Reminder getReminder(Long reminderId) {
        return this.reminderDAO.getReminder(reminderId);
    }

    public List getReminders(Long eventId) {
        return this.reminderDAO.getReminders(eventId);
    }

    public List getReminders(Date startDate, Date endDate) {
        List baseReminders = this.reminderDAO.getBaseReminders(startDate, endDate);
        ArrayList<Reminder> reminders = new ArrayList<Reminder>();
        for (int i = 0; i < baseReminders.size(); ++i) {
            Reminder reminder = this.parseReminder((Reminder)baseReminders.get(i), startDate, endDate);
            if (reminder == null) continue;
            reminders.add(reminder);
        }
        return reminders;
    }

    private Reminder parseReminder(Reminder reminder, Date startDate, Date endDate) {
        if (StringUtils.isNotBlank((String)reminder.getEvent().getRecurrenceRule())) {
            return Helper.getNearRecurrenceEventReminder((Reminder)reminder, (Date)startDate, (Date)endDate);
        }
        return reminder;
    }

    public List getNeedProcessRemindersFromQueue(Date date) {
        Reminder reminder;
        ArrayList<Reminder> list = new ArrayList<Reminder>();
        Iterator it = this.remindersQueue.iterator();
        while (it.hasNext() && (reminder = (Reminder)it.next()).getRemindDate().before(date)) {
            Reminder r = this.getReminder(reminder.getId());
            r.setEvent(this.eventManager.getEvent(reminder.getEventId()));
            if (reminder.equals((Object)r)) {
                list.add(reminder);
                continue;
            }
            it.remove();
        }
        return list;
    }

    public void updateRemindersQueue(Date startDate, Date endDate) {
        this.remindersQueue.addAll(this.getReminders(startDate, endDate));
    }

    public void removeReminderFromQueue(Reminder reminder) {
        this.remindersQueue.remove(reminder);
    }

    public void removeReminder(Long reminderId) {
        this.reminderDAO.removeReminder(reminderId);
    }

    public boolean sendReminder(Reminder reminder) {
        try {
            List personalCalendars = this.calendarManager.getPersonalCalendars(reminder.getEvent().getCalendarId());
            String[] receivers = new String[personalCalendars.size()];
            for (int i = 0; i < personalCalendars.size(); ++i) {
                receivers[i] = ((PersonalCalendar)personalCalendars.get(i)).getCreator();
            }
            Message message = new Message();
            message.setReceivers(receivers);
            message.setSender(SystemConfig.getProperty((String)"calendar.remind.sender"));
            message.setCreateTime(new Date());
            message.setSubject(this.getSubject(reminder));
            message.setContent(this.getContent(reminder, reminder.getMethod() == 3, this.calendarManager.getCalendar(reminder.getEvent().getCalendarId()).getName()));
            logger.debug("send reminder:[{}]", (Object)reminder);
            switch (reminder.getMethod()) {
                case 1: {
                    return this.messageService.sendMessage(message);
                }
                case 2: {
                    return this.messageService.sendMail(message);
                }
                case 3: {
                    return this.messageService.sendSms(message);
                }
            }
        }
        catch (Exception e) {
            logger.debug("send reminder error:[{}]", (Throwable)e);
        }
        return true;
    }

    private String getSubject(Reminder reminder) {
        Event event = reminder.getEvent();
        return MessageFormat.format(SystemConfig.getProperty((String)"calendar.remind.subject"), event.getTitle(), event.isWholeDay() ? tsdf.format(event.getStartTime()) : tsdf.format(event.getStartTime()) + " to " + tsdf.format(event.getEndTime()), StringUtils.trimToEmpty((String)event.getLocation()));
    }

    private String getContent(Reminder reminder, boolean isSms, String calendarName) {
        Event event = reminder.getEvent();
        return MessageFormat.format(SystemConfig.getProperty((String)(isSms ? "calendar.remind.content.sms" : "calendar.remind.content")), SystemConfig.getProperty((String)"calendar.url"), event.getTitle(), event.isWholeDay() ? tsdf.format(event.getStartTime()) : tsdf.format(event.getStartTime()) + " to " + tsdf.format(event.getEndTime()), StringUtils.trimToEmpty((String)event.getDescription()), StringUtils.trimToEmpty((String)event.getLocation()), StringUtils.trimToEmpty((String)event.getUrl()), calendarName, event.getColor());
    }
}

