/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.egov.calendar.service.impl;

import com.gtis.egov.calendar.Helper;
import com.gtis.egov.calendar.dao.EventDAO;
import com.gtis.egov.calendar.model.Event;
import com.gtis.egov.calendar.model.Reminder;
import com.gtis.egov.calendar.service.EventManager;
import com.gtis.egov.calendar.service.ReminderManager;
import com.gtis.egov.calendar.utils.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class EventManagerImpl
implements EventManager {
    private EventDAO eventDAO;
    private ReminderManager reminderManager;

    public void setEventDAO(EventDAO eventDAO) {
        this.eventDAO = eventDAO;
    }

    public void setReminderManager(ReminderManager reminderManager) {
        this.reminderManager = reminderManager;
    }

    public Event saveEvent(Event event) {
        this.eventDAO.saveEvent(event);
        List reminders = this.reminderManager.getReminders(event.getId());
        for (int i = 0; i < reminders.size(); ++i) {
            Reminder reminder = (Reminder)reminders.get(i);
            reminder.setEvent(event);
            this.reminderManager.saveReminder(reminder);
        }
        return event;
    }

    public Event getEvent(Long eventId) {
        return this.eventDAO.getEvent(eventId);
    }

    public List getEvents(String userId, Long[] calendarIds, Date startDate, Date endDate) {
        return EventManagerImpl.convertEvents((List)this.eventDAO.getBaseEvents(userId, calendarIds, startDate, endDate), (Date)startDate, (Date)endDate);
    }

    public List getAllEvents(String userId, Date startDate, Date endDate) {
        return EventManagerImpl.convertEvents((List)this.eventDAO.getUserBaseEvents(userId, startDate, endDate), (Date)startDate, (Date)endDate);
    }

    public void removeEvent(Long eventId) {
        this.eventDAO.removeEvent(eventId);
        this.reminderManager.removeReminder(eventId);
    }

    private static List convertEvents(List baseEvents, Date startDate, Date endDate) {
        ArrayList<Event> events = new ArrayList<Event>();
        for (int i = 0; i < baseEvents.size(); ++i) {
            Event baseEvent = (Event)baseEvents.get(i);
            if (StringUtils.isBlank((String)baseEvent.getRecurrenceRule())) {
                events.add(baseEvent);
                continue;
            }
            events.addAll(Helper.getRecurrenceEvents((Event)baseEvent, (Date)startDate, (Date)endDate));
        }
        return events;
    }
}

