/*
 * Decompiled with CFR 0.152.
 */
package com.gtis.egov.calendar.service.impl;

import com.gtis.egov.calendar.dao.CalendarDAO;
import com.gtis.egov.calendar.dao.EventDAO;
import com.gtis.egov.calendar.dao.ReminderDAO;
import com.gtis.egov.calendar.model.Calendar;
import com.gtis.egov.calendar.model.PersonalCalendar;
import com.gtis.egov.calendar.service.CalendarManager;
import com.gtis.egov.generic.SystemConfig;
import com.gtis.egov.generic.User;
import com.gtis.egov.generic.UserService;
import com.wiscom.generic.base.util.PaginationSupport;
import java.util.Date;
import java.util.List;
import net.sf.ehcache.Ehcache;

public class CalendarManagerImpl
implements CalendarManager {
    private CalendarDAO calendarDAO;
    private EventDAO eventDAO;
    private ReminderDAO reminderDAO;
    private UserService userService;
    private Ehcache userNameCache;

    public void setCalendarDAO(CalendarDAO calendarDAO) {
        this.calendarDAO = calendarDAO;
    }

    public void setEventDAO(EventDAO eventDAO) {
        this.eventDAO = eventDAO;
    }

    public void setReminderDAO(ReminderDAO reminderDAO) {
        this.reminderDAO = reminderDAO;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public Calendar saveCalendar(Calendar calendar) {
        this.calendarDAO.saveCalendar(calendar);
        return calendar;
    }

    public Calendar getCalendar(Long calendarId) {
        return this.calendarDAO.getCalendar(calendarId);
    }

    public PaginationSupport searchCalendars(String term, Short[] types, int start, int num) {
        return this.calendarDAO.searchCalendars(term, types, start, num);
    }

    public PaginationSupport searchFriendCalendars(String term, String userId, int start, int num) {
        return this.calendarDAO.searchFriendCalendars(term, userId, start, num);
    }

    public void removeCalendar(Long calendarId) {
        this.calendarDAO.removeCalendar(calendarId);
        this.calendarDAO.removePersonalCalendars(calendarId);
        this.eventDAO.removeEvents(calendarId);
        this.reminderDAO.removeRemindersByCalendarId(calendarId);
    }

    public PersonalCalendar savePersonalCalendar(PersonalCalendar personalCalendar) {
        return this.calendarDAO.savePersonalCalendar(personalCalendar);
    }

    public PersonalCalendar getPersonalCalendar(Long personalCalendarId) {
        return this.calendarDAO.getPersonalCalendar(personalCalendarId);
    }

    public PersonalCalendar getPersonalCalendar(Long calendarId, String userId) {
        return this.calendarDAO.getPersonalCalendar(calendarId, userId);
    }

    public List getPersonalCalendars(Long calendarId) {
        return this.calendarDAO.getPersonalCalendars(calendarId);
    }

    public void syncGroupCalendarToPersonalCalendar(String userId) {
        List groupCalendars = this.calendarDAO.getAsynchronousGroupCalendars(userId);
        for (int i = 0; i < groupCalendars.size(); ++i) {
            Calendar calendar = (Calendar)groupCalendars.get(i);
            PersonalCalendar personalCalendar = new PersonalCalendar();
            personalCalendar.setCalendarId(calendar.getId());
            personalCalendar.setName(calendar.getName());
            personalCalendar.setCreator(userId);
            personalCalendar.setAddTime(new Date());
            personalCalendar.setColor(calendar.getColor());
            this.calendarDAO.savePersonalCalendar(personalCalendar);
        }
    }

    public void syncStandardCalendarToPersonalCalendar(String userId) {
        List standardCalendars = this.calendarDAO.getAsynchronousStandardCalendars(userId);
        for (int i = 0; i < standardCalendars.size(); ++i) {
            Calendar calendar = (Calendar)standardCalendars.get(i);
            PersonalCalendar personalCalendar = new PersonalCalendar();
            personalCalendar.setCalendarId(calendar.getId());
            personalCalendar.setName(calendar.getName());
            personalCalendar.setCreator(userId);
            personalCalendar.setAddTime(new Date());
            personalCalendar.setColor(calendar.getColor());
            this.calendarDAO.savePersonalCalendar(personalCalendar);
        }
    }

    public List getPersonalCalendars(String userId, Boolean isVisible) {
        this.syncGroupCalendarToPersonalCalendar(userId);
        this.syncStandardCalendarToPersonalCalendar(userId);
        List personalCalendars = this.calendarDAO.getPersonalCalendars(userId, (short)1);
        if (personalCalendars.isEmpty()) {
            Calendar calendar = new Calendar();
            Date now = new Date();
            String name = SystemConfig.getProperty((String)"calendar.defaultPersonalCalendarName");
            calendar.setCreator(userId);
            calendar.setCreateTime(now);
            calendar.setName(name);
            calendar.setColor("#668CB3");
            calendar.setType((short)1);
            this.saveCalendar(calendar);
            PersonalCalendar personalCalendar = new PersonalCalendar();
            personalCalendar.setCreator(userId);
            personalCalendar.setAddTime(now);
            personalCalendar.setCalendarId(calendar.getId());
            personalCalendar.setName(name);
            personalCalendar.setColor("#668CB3");
            this.savePersonalCalendar(personalCalendar);
        }
        personalCalendars = this.calendarDAO.getPersonalCalendars(userId, isVisible);
        this.upadteCreatorName(personalCalendars);
        return personalCalendars;
    }

    public List getStandardPersonalCalendars(String userId) {
        this.syncStandardCalendarToPersonalCalendar(userId);
        List personalCalendars = this.calendarDAO.getStandardPersonalCalendars(userId);
        this.upadteCreatorName(personalCalendars);
        return personalCalendars;
    }

    public List getGroupCalendars(String groupId) {
        return this.calendarDAO.getGroupCalendars(groupId);
    }

    public List getGroupPersonalCalendars(String userId, String groupId) {
        this.syncGroupCalendarToPersonalCalendar(userId);
        List personalCalendars = this.calendarDAO.getGroupPersonalCalendars(userId, groupId);
        this.upadteCreatorName(personalCalendars);
        return personalCalendars;
    }

    public void removePersonalCalendar(Long personalCalendarId) {
        this.calendarDAO.removePersonalCalendar(personalCalendarId);
    }

    public void changePersonalCalendarVisibleStatus(String userId, Long[] personalCalendarIds, boolean isVisible) {
        for (int i = 0; i < personalCalendarIds.length; ++i) {
            Long id = personalCalendarIds[i];
            PersonalCalendar personalCalendar = this.calendarDAO.getPersonalCalendar(id);
            if (!personalCalendar.getCreator().equals(userId) || isVisible == personalCalendar.isVisible()) continue;
            personalCalendar.setVisible(isVisible);
            this.calendarDAO.savePersonalCalendar(personalCalendar);
        }
    }

    public void changePersonalCalendarSelectedStatus(String userId, Long[] personalCalendarIds, boolean isSelected) {
        for (int i = 0; i < personalCalendarIds.length; ++i) {
            Long id = personalCalendarIds[i];
            PersonalCalendar personalCalendar = this.calendarDAO.getPersonalCalendar(id);
            if (!personalCalendar.getCreator().equals(userId) || isSelected == personalCalendar.isSelected()) continue;
            personalCalendar.setSelected(isSelected);
            this.calendarDAO.savePersonalCalendar(personalCalendar);
        }
    }

    public void changePersonalCalendarColor(String userId, Long personalCalendarId, String color) {
        PersonalCalendar personalCalendar = this.calendarDAO.getPersonalCalendar(personalCalendarId);
        if (color.equals(personalCalendar.getColor())) {
            return;
        }
        personalCalendar.setColor(color);
        this.calendarDAO.savePersonalCalendar(personalCalendar);
    }

    private void upadteCreatorName(List personalCalendars) {
        for (int i = 0; i < personalCalendars.size(); ++i) {
            PersonalCalendar personalCalendar = (PersonalCalendar)personalCalendars.get(i);
            User user = this.userService.loadUser(personalCalendar.getCalendarCreator());
            personalCalendar.setCreatorName(user.getName());
        }
    }
}

